/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.proxy.event;

import java.math.BigInteger;
import org.eclipse.ptp.core.proxy.event.IProxyEvent;
import org.eclipse.ptp.core.proxy.event.ProxyEvent;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.ExtFormat;
import org.eclipse.ptp.debug.core.aif.AIF;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.external.core.cdi.Condition;
import org.eclipse.ptp.debug.external.core.cdi.Locator;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.LineBreakpoint;
import org.eclipse.ptp.debug.external.core.cdi.model.DataReadMemoryInfo;
import org.eclipse.ptp.debug.external.core.cdi.model.LineLocation;
import org.eclipse.ptp.debug.external.core.cdi.model.Memory;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugSignal;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugStackframe;
import org.eclipse.ptp.debug.external.core.proxy.event.AbstractProxyDebugEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugArgsEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugBreakpointHitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugBreakpointSetEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugDataEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugDataExpValueEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugErrorEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugExitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugInfoThreadsEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugInitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugMemoryInfoEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugOKEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugPartialAIFEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSetThreadSelectEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSignalEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSignalExitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSignalsEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStackInfoDepthEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStackframeEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStepEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSuspendEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugTypeEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugVarsEvent;

public class ProxyDebugEvent
extends ProxyEvent {
    public static IProxyEvent toEvent(String str) {
        AbstractProxyDebugEvent evt = null;
        String[] args = str.split(" ");
        int type = Integer.parseInt(args[0]);
        BitList set = ProxyEvent.decodeBitSet((String)args[1]);
        switch (type) {
            case 111: {
                evt = new ProxyDebugOKEvent(set);
                break;
            }
            case 112: {
                int errCode = Integer.parseInt(args[2]);
                evt = new ProxyDebugErrorEvent(set, errCode, ProxyDebugEvent.decodeString((String)args[3]));
                break;
            }
            case 110: {
                int num_servers = Integer.parseInt(args[2]);
                evt = new ProxyDebugInitEvent(set, num_servers);
                break;
            }
            case 113: {
                switch (Integer.parseInt(args[2])) {
                    case 0: {
                        int hitId = Integer.parseInt(args[3]);
                        int bpTid = Integer.parseInt(args[4]);
                        int numVars = Integer.parseInt(args[5]);
                        String[] vars = new String[numVars];
                        int i = 0;
                        while (i < numVars) {
                            vars[i] = ProxyDebugEvent.decodeString((String)args[i + 6]);
                            ++i;
                        }
                        evt = new ProxyDebugBreakpointHitEvent(set, hitId, bpTid, vars);
                        break;
                    }
                    case 1: {
                        int sigTid = Integer.parseInt(args[13]);
                        IPCDILocator sigLoc = null;
                        if (args[8].compareTo("*") != 0) {
                            sigLoc = ProxyDebugEvent.toLocator(args[9], args[10], args[11], args[12]);
                        }
                        int numVars = Integer.parseInt(args[14]);
                        String[] vars = new String[numVars];
                        int i = 0;
                        while (i < numVars) {
                            vars[i] = ProxyDebugEvent.decodeString((String)args[i + 15]);
                            ++i;
                        }
                        evt = new ProxyDebugSignalEvent(set, ProxyDebugEvent.decodeString((String)args[3]), ProxyDebugEvent.decodeString((String)args[7]), sigLoc, sigTid, vars);
                        break;
                    }
                    case 2: {
                        ProxyDebugStackframe frame = ProxyDebugEvent.toFrame(args[3], args[4], args[5], args[7], args[6]);
                        int stTid = Integer.parseInt(args[8]);
                        int numVars = Integer.parseInt(args[9]);
                        String[] vars = new String[numVars];
                        int i = 0;
                        while (i < numVars) {
                            vars[i] = ProxyDebugEvent.decodeString((String)args[i + 10]);
                            ++i;
                        }
                        evt = new ProxyDebugStepEvent(set, frame, stTid, vars);
                        break;
                    }
                    case 3: {
                        IPCDILocator suspendLoc = ProxyDebugEvent.toLocator(args[4], args[5], args[6], args[7]);
                        int susTid = Integer.parseInt(args[8]);
                        int numVars = Integer.parseInt(args[9]);
                        String[] vars = new String[numVars];
                        int i = 0;
                        while (i < numVars) {
                            vars[i] = ProxyDebugEvent.decodeString((String)args[i + 10]);
                            ++i;
                        }
                        evt = new ProxyDebugSuspendEvent(set, suspendLoc, susTid, vars);
                    }
                }
                break;
            }
            case 104: {
                int setId = Integer.parseInt(args[2]);
                IPCDILineLocation loc = ProxyDebugEvent.toLineLocation(args[8], args[11]);
                IPCDIBreakpoint bpt = ProxyDebugEvent.toBreakpoint(args[4], args[5], args[6], args[7], loc);
                evt = new ProxyDebugBreakpointSetEvent(set, setId, bpt);
                break;
            }
            case 119: {
                int numSignals = Integer.parseInt(args[2]);
                ProxyDebugSignal[] signals = new ProxyDebugSignal[numSignals];
                int i = 0;
                while (i < numSignals) {
                    signals[i] = new ProxyDebugSignal(ProxyDebugEvent.decodeString((String)args[5 * i + 3]), ProxyDebugEvent.toboolean(Integer.parseInt(args[5 * i + 4])), ProxyDebugEvent.toboolean(Integer.parseInt(args[5 * i + 5])), ProxyDebugEvent.toboolean(Integer.parseInt(args[5 * i + 6])), ProxyDebugEvent.decodeString((String)args[5 * i + 7]));
                    ++i;
                }
                evt = new ProxyDebugSignalsEvent(set, signals);
                break;
            }
            case 102: {
                switch (Integer.parseInt(args[2])) {
                    case 0: {
                        int status = Integer.parseInt(args[3]);
                        evt = new ProxyDebugExitEvent(set, status);
                        break;
                    }
                    case 1: {
                        evt = new ProxyDebugSignalExitEvent(set, ProxyDebugEvent.decodeString((String)args[3]), ProxyDebugEvent.decodeString((String)args[7]));
                    }
                }
                break;
            }
            case 105: {
                int numFrames = Integer.parseInt(args[2]);
                ProxyDebugStackframe[] frames = new ProxyDebugStackframe[numFrames];
                int i = 0;
                while (i < numFrames) {
                    frames[i] = ProxyDebugEvent.toFrame(args[5 * i + 3], args[5 * i + 4], args[5 * i + 5], args[5 * i + 7], args[5 * i + 6]);
                    ++i;
                }
                evt = new ProxyDebugStackframeEvent(set, frames);
                break;
            }
            case 115: {
                int current_thread_id = Integer.parseInt(args[2]);
                ProxyDebugStackframe th_frame = ProxyDebugEvent.toFrame(args[3], args[4], args[5], args[7], args[6]);
                evt = new ProxyDebugSetThreadSelectEvent(set, current_thread_id, th_frame);
                break;
            }
            case 114: {
                int numThreads = Integer.parseInt(args[3]);
                String[] thread_ids = new String[numThreads + 1];
                thread_ids[0] = args[2];
                int i = 1;
                while (i < thread_ids.length) {
                    thread_ids[i] = ProxyDebugEvent.decodeString((String)args[i + 3]);
                    ++i;
                }
                evt = new ProxyDebugInfoThreadsEvent(set, thread_ids);
                break;
            }
            case 116: {
                int depth = Integer.parseInt(args[2]);
                evt = new ProxyDebugStackInfoDepthEvent(set, depth);
                break;
            }
            case 117: {
                int numMemories = Integer.parseInt(args[9]);
                Memory[] memories = new Memory[numMemories];
                int data_len = 0;
                int i = 0;
                while (i < numMemories) {
                    int new_data_len = Integer.parseInt(args[data_len * i + 12]);
                    String addr = ProxyDebugEvent.decodeString((String)args[data_len * i + 10]);
                    String ascii = ProxyDebugEvent.decodeString((String)args[data_len * i + 11]);
                    String[] data_str = new String[new_data_len];
                    int j = 0;
                    while (j < new_data_len) {
                        data_str[j] = ProxyDebugEvent.decodeString((String)args[data_len * i + 13 + j]);
                        ++j;
                    }
                    data_len = new_data_len;
                    memories[i] = new Memory(addr, ascii, data_str);
                    ++i;
                }
                evt = new ProxyDebugMemoryInfoEvent(set, ProxyDebugEvent.toMemoryInfo(args[2], args[3], args[4], args[5], args[6], args[7], args[8], memories));
                break;
            }
            case 108: {
                int numVars = Integer.parseInt(args[2]);
                String[] vars = new String[numVars];
                int i = 0;
                while (i < numVars) {
                    vars[i] = ProxyDebugEvent.decodeString((String)args[i + 3]);
                    ++i;
                }
                evt = new ProxyDebugVarsEvent(set, vars);
                break;
            }
            case 109: {
                int numArgs = Integer.parseInt(args[2]);
                String[] arg_strs = new String[numArgs];
                int i = 0;
                while (i < numArgs) {
                    arg_strs[i] = ProxyDebugEvent.decodeString((String)args[i + 3]);
                    ++i;
                }
                evt = new ProxyDebugArgsEvent(set, arg_strs);
                break;
            }
            case 107: {
                evt = new ProxyDebugTypeEvent(set, ProxyDebugEvent.decodeString((String)args[2]));
                break;
            }
            case 106: {
                AIF data = new AIF(ProxyDebugEvent.decodeString((String)args[2]), ProxyDebugEvent.decodeBytes((String)args[3]), ProxyDebugEvent.decodeString((String)args[4]));
                evt = new ProxyDebugDataEvent(set, (IAIF)data);
                break;
            }
            case 120: {
                evt = new ProxyDebugDataExpValueEvent(set, ProxyDebugEvent.decodeString((String)args[2]));
                break;
            }
            case 121: {
                AIF partial_data = new AIF(ProxyDebugEvent.decodeString((String)args[2]), ProxyDebugEvent.decodeBytes((String)args[3]), ProxyDebugEvent.decodeString((String)args[4]));
                evt = new ProxyDebugPartialAIFEvent(set, (IAIF)partial_data, ProxyDebugEvent.decodeString((String)args[5]));
            }
        }
        return evt;
    }

    public static BigInteger decodeAddr(String str) {
        String[] parts = str.split(":");
        int len = Integer.parseInt(parts[0], 16) - 1;
        byte[] strBytes = new byte[len];
        int i = 0;
        int p = 0;
        while (i < len) {
            byte c = (byte)((Character.digit(parts[1].charAt(p), 16) & 0xF) << 4);
            strBytes[i] = c = (byte)(c | (byte)(Character.digit(parts[1].charAt(p + 1), 16) & 0xF));
            ++i;
            p += 2;
        }
        BigInteger a = new BigInteger(strBytes);
        return a;
    }

    public static IPCDIBreakpoint toBreakpoint(String ignoreStr, String spec, String del, String typeStr, IPCDILineLocation loc) {
        LineBreakpoint bpt = null;
        int ignore = Integer.parseInt(ignoreStr);
        Condition cond = new Condition(ignore, null, null);
        String type = ProxyDebugEvent.decodeString((String)typeStr);
        int typeVal = type.compareTo("breakpoint") == 0 ? 0 : (type.compareTo("hw") == 0 ? 2 : 1);
        bpt = new LineBreakpoint(typeVal, loc, (IPCDICondition)cond);
        return bpt;
    }

    public static IPCDILineLocation toLineLocation(String fileStr, String lineStr) {
        String file = ProxyDebugEvent.decodeString((String)fileStr);
        int line = Integer.parseInt(lineStr);
        return new LineLocation(file, line);
    }

    public static IPCDILocator toLocator(String fileStr, String funcStr, String addrStr, String lineStr) {
        String file = ProxyDebugEvent.decodeString((String)fileStr);
        String func = ProxyDebugEvent.decodeString((String)funcStr);
        int line = Integer.parseInt(lineStr);
        String addr = ProxyDebugEvent.decodeString((String)addrStr);
        return new Locator(file, func, line, ExtFormat.getBigInteger((String)addr));
    }

    public static ProxyDebugStackframe toFrame(String level, String file, String func, String line, String addr) {
        int stepLevel = Integer.parseInt(level);
        return new ProxyDebugStackframe(stepLevel, ProxyDebugEvent.toLocator(file, func, addr, line));
    }

    public static DataReadMemoryInfo toMemoryInfo(String addr, String nextRow, String prevRow, String nextPage, String prevPage, String numBytes, String totalBytes, Memory[] memories) {
        return new DataReadMemoryInfo(ProxyDebugEvent.decodeString((String)addr), Long.parseLong(nextRow), Long.parseLong(prevRow), Long.parseLong(nextPage), Long.parseLong(prevPage), Long.parseLong(numBytes), Long.parseLong(totalBytes), memories);
    }

    public static boolean toboolean(int value) {
        return value != 0;
    }
}

