/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.debug.core.DebugJobStorage;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.IPDebugEventListener;
import org.eclipse.ptp.debug.core.PCDIDebugModel;
import org.eclipse.ptp.debug.core.PTPPreferenceStore;
import org.eclipse.ptp.debug.core.events.IPDebugEvent;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocation;
import org.eclipse.ptp.debug.core.sourcelookup.PSourceLookupDirector;
import org.eclipse.ptp.debug.internal.core.PDebugConfiguration;
import org.eclipse.ptp.debug.internal.core.sourcelookup.CommonSourceLookupDirector;
import org.eclipse.ptp.debug.internal.core.sourcelookup.SourceUtils;
import org.osgi.framework.BundleContext;

public class PTPDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.debug.core";
    public static final int INTERNAL_ERROR = 1000;
    private static PTPDebugCorePlugin plugin;
    private HashMap fDebugConfigurations;
    private static Logger logger;
    private Level loggingLevel = Level.FINE;
    private CommonSourceLookupDirector fCommonSourceLookupDirector;
    private static PCDIDebugModel debugModel;
    private EventDispatchJob dispatchJob = new EventDispatchJob();
    private ListenerList fEventListeners = new ListenerList();
    private List fEventQueue = new ArrayList();
    private boolean fShuttingDown = false;
    private int fDispatching = 0;

    static {
        debugModel = null;
    }

    public PTPDebugCorePlugin() {
        plugin = this;
    }

    public static PTPDebugCorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        if (PTPDebugCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPDebugCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public IPreferenceStore getPTPPreferenceStore() {
        return new PTPPreferenceStore(this.getPluginPreferences());
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, "Internal error logged from CDI Debug: ", top));
    }

    public static void log(IStatus status) {
        PTPDebugCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        PTPDebugCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, null));
    }

    private void initializeDebugConfiguration() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PTPDebugCorePlugin.getUniqueIdentifier(), "PTPDebugger");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fDebugConfigurations = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            PDebugConfiguration configType = new PDebugConfiguration(configurationElement);
            this.fDebugConfigurations.put(configType.getID(), configType);
            ++i;
        }
    }

    public IPDebugConfiguration[] getDebugConfigurations() {
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        return this.fDebugConfigurations.values().toArray(new IPDebugConfiguration[0]);
    }

    public IPDebugConfiguration getDebugConfiguration(String id) throws CoreException {
        IPDebugConfiguration dbgCfg;
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        if ((dbgCfg = (IPDebugConfiguration)this.fDebugConfigurations.get(id)) == null) {
            Status status = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 100, "PTPDebugCorePlugin Debug Configuration Error", null);
            throw new CoreException((IStatus)status);
        }
        return dbgCfg;
    }

    public static PCDIDebugModel getDebugModel() {
        return debugModel;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        debugModel = new PCDIDebugModel();
        this.initializeCommonSourceLookupDirector();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.setShuttingDown(true);
            this.disposeCommonSourceLookupDirector();
            debugModel.shutdown();
            DebugJobStorage.removeDebugStorages();
        }
        finally {
            super.stop(context);
        }
    }

    private void initializeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector == null) {
            this.fCommonSourceLookupDirector = new CommonSourceLookupDirector();
            String newMemento = PTPDebugCorePlugin.getDefault().getPluginPreferences().getString(IPDebugConstants.PREF_COMMON_SOURCE_CONTAINERS);
            if (newMemento.length() == 0) {
                this.convertSourceLocations(this.fCommonSourceLookupDirector);
            } else {
                try {
                    this.fCommonSourceLookupDirector.initializeFromMemento(newMemento);
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.log(e.getStatus());
                }
            }
        }
    }

    private void disposeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector != null) {
            this.fCommonSourceLookupDirector.dispose();
        }
    }

    public PSourceLookupDirector getCommonSourceLookupDirector() {
        return this.fCommonSourceLookupDirector;
    }

    private void convertSourceLocations(CommonSourceLookupDirector director) {
        director.setSourceContainers(SourceUtils.convertSourceLocations(this.getCommonSourceLocations()));
    }

    public IPSourceLocation[] getCommonSourceLocations() {
        return SourceUtils.getCommonSourceLocationsFromMemento(PTPDebugCorePlugin.getDefault().getPluginPreferences().getString(IPDebugConstants.PREF_SOURCE_LOCATIONS));
    }

    public Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            Handler[] handlers = logger.getHandlers();
            int index = 0;
            while (index < handlers.length) {
                logger.removeHandler(handlers[index]);
                ++index;
            }
            ConsoleHandler console = new ConsoleHandler();
            console.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    String out = record.getLevel() + " : " + record.getSourceClassName() + "." + record.getSourceMethodName();
                    if (!record.getMessage().equals("")) {
                        out = String.valueOf(out) + " : " + record.getMessage();
                    }
                    out = String.valueOf(out) + "\n";
                    return out;
                }
            });
            console.setLevel(this.loggingLevel);
            logger.addHandler(console);
            logger.setLevel(this.loggingLevel);
        }
        return logger;
    }

    private synchronized void setDispatching(boolean dispatching) {
        this.fDispatching = dispatching ? ++this.fDispatching : --this.fDispatching;
    }

    public synchronized boolean isDispatching() {
        return this.fDispatching > 0;
    }

    public boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    public void setShuttingDown(boolean value) {
        this.fShuttingDown = value;
    }

    private Object[] getEventListeners() {
        return this.fEventListeners.getListeners();
    }

    public void addDebugEventListener(IPDebugEventListener listener) {
        this.fEventListeners.add((Object)listener);
    }

    public void removeDebugEventListener(IPDebugEventListener listener) {
        this.fEventListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDebugEvent(IPDebugEvent event) {
        if (this.isShuttingDown() || event == null || this.fEventListeners.isEmpty()) {
            return;
        }
        List list = this.fEventQueue;
        synchronized (list) {
            this.fEventQueue.add(event);
        }
        this.dispatchJob.schedule();
    }

    public int getCommandTimeout() {
        return this.getPluginPreferences().getInt(IPDebugConstants.PREF_PTP_DEBUG_COMM_TIMEOUT);
    }

    class EventDispatchJob
    extends Job {
        private EventNotifier fNotifier;

        public EventDispatchJob() {
            super("EventDispatchJob");
            this.fNotifier = new EventNotifier();
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!PTPDebugCorePlugin.this.fEventQueue.isEmpty()) {
                IPDebugEvent event = null;
                List list = PTPDebugCorePlugin.this.fEventQueue;
                synchronized (list) {
                    if (!PTPDebugCorePlugin.this.fEventQueue.isEmpty()) {
                        event = (IPDebugEvent)PTPDebugCorePlugin.this.fEventQueue.remove(0);
                    }
                }
                if (event == null) continue;
                this.fNotifier.dispatch(event);
            }
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            return this.shouldSchedule();
        }

        public boolean shouldSchedule() {
            return !PTPDebugCorePlugin.this.isShuttingDown() && !PTPDebugCorePlugin.this.fEventListeners.isEmpty();
        }
    }

    class EventNotifier
    implements ISafeRunnable {
        private IPDebugEvent fEvent;
        private IPDebugEventListener fListener;

        EventNotifier() {
        }

        public void handleException(Throwable exception) {
            PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, "PTPDebugCorePlugin occurred exception while dispacthing debug event", exception));
        }

        public void run() throws Exception {
            this.fListener.handleDebugEvent(this.fEvent);
        }

        public void dispatch(IPDebugEvent event) {
            this.fEvent = event;
            try {
                PTPDebugCorePlugin.this.setDispatching(true);
                Object[] listeners = PTPDebugCorePlugin.this.getEventListeners();
                int i = 0;
                while (i < listeners.length) {
                    this.fListener = (IPDebugEventListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)this);
                    ++i;
                }
            }
            finally {
                PTPDebugCorePlugin.this.setDispatching(false);
            }
            this.fEvent = null;
            this.fListener = null;
        }
    }
}

