/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.aif.ValueDerived;

public class AIFValueArray
extends ValueDerived
implements IAIFValueArray {
    IAIFValue[] values = new IAIFValue[0];

    public AIFValueArray(IAIFTypeArray type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        IAIFTypeArray arrType = (IAIFTypeArray)this.type;
        IAIFType baseType = arrType.getBaseType();
        this.values = new IAIFValue[arrType.getRange()];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = AIFFactory.getAIFValue((IValueParent)this, baseType, buffer);
            this.size += this.values[i].sizeof();
            ++i;
        }
    }

    public IAIFValue[] getValues() {
        return this.values;
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.getString();
        }
        return this.result;
    }

    private String getString() throws AIFException {
        String content = "[";
        int i = 0;
        while (i < this.values.length) {
            content = String.valueOf(content) + this.values[i].getValueString();
            if (i < this.values.length - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        content = String.valueOf(content) + "]";
        return content;
    }
}

