/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.internal.core.model.AbstractPVariable;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;

public abstract class AbstractPValue
extends PDebugElement
implements IPValue {
    private AbstractPVariable fParent = null;

    public AbstractPValue(AbstractPVariable parent) {
        super((PDebugTarget)parent.getDebugTarget());
        this.fParent = parent;
    }

    public AbstractPVariable getParentVariable() {
        return this.fParent;
    }

    public String evaluateAsExpression(IPStackFrame frame) {
        String valueString = "";
        AbstractPVariable parent = this.getParentVariable();
        if (parent != null && frame != null && frame.canEvaluate()) {
            try {
                valueString = frame.evaluateExpressionToString(parent.getExpressionString());
            }
            catch (DebugException e) {
                valueString = e.getMessage();
            }
        }
        return valueString;
    }

    protected abstract void setChanged(boolean var1);

    public abstract void dispose();

    protected abstract void reset();

    protected abstract void preserve();
}

