/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExpression;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIObject;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariableDescriptor;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPType;
import org.eclipse.ptp.debug.core.model.PVariableFormat;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.PLocalVariable;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;
import org.eclipse.ptp.debug.internal.core.model.PType;
import org.eclipse.ptp.debug.internal.core.model.PValueFactory;

public class PExpression
extends PLocalVariable
implements IExpression {
    private String fText;
    private IPCDIExpression fCDIExpression;
    private PStackFrame fStackFrame;
    private IValue fValue = PValueFactory.NULL_VALUE;
    private IPType fType;

    public PExpression(PStackFrame frame, IPCDIExpression cdiExpression, IPCDIVariableDescriptor varObject) {
        super(frame, varObject);
        this.setFormat(PVariableFormat.getFormat(PTPDebugCorePlugin.getDefault().getPluginPreferences().getInt(IPDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fText = cdiExpression.getExpressionText();
        this.fCDIExpression = cdiExpression;
        this.fStackFrame = frame;
    }

    public String getExpressionText() {
        return this.fText;
    }

    public void handleDebugEvents(IPCDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IPCDIObject source;
            IPCDIEvent event = events[i];
            if (event instanceof IPCDIResumedEvent && (source = event.getSource()) != null) {
                IPCDITarget cdiTarget = source.getTarget();
                if (this.getCDITarget().equals(cdiTarget)) {
                    this.setChanged(false);
                    this.resetValue();
                }
            }
            ++i;
        }
        super.handleDebugEvents(events);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean canEnableDisable() {
        return true;
    }

    protected boolean isBookkeepingEnabled() {
        return false;
    }

    public IValue getValue() {
        PStackFrame frame = (PStackFrame)this.getStackFrame();
        try {
            return this.getValue(frame);
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    protected synchronized IValue getValue(PStackFrame frame) throws DebugException {
        if (this.fValue.equals(PValueFactory.NULL_VALUE) && frame.isSuspended()) {
            try {
                IPCDIVariable variable = this.fCDIExpression.getCDIVariable(frame.getCDIStackFrame());
                if (variable != null) {
                    IAIFValue aifValue = variable.getValue();
                    if (aifValue != null) {
                        int[] dims;
                        PType type;
                        if (aifValue instanceof IAIFValueArray && (type = new PType(aifValue.getType())) != null && type.isArray() && (dims = type.getArrayDimensions()).length > 0 && dims[0] > 0) {
                            this.fValue = PValueFactory.createIndexedValue(this, variable, 0, dims[0]);
                        }
                    } else {
                        this.fValue = PValueFactory.createValue(this, variable);
                    }
                }
            }
            catch (PCDIException e) {
                PExpression.targetRequestFailed(e.getMessage(), null);
            }
        }
        return this.fValue;
    }

    protected IPStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    protected void resetValue() {
        if (this.fValue instanceof AbstractPValue) {
            ((AbstractPValue)this.fValue).reset();
        }
        this.fValue = PValueFactory.NULL_VALUE;
    }

    public String getExpressionString() throws DebugException {
        return this.getExpressionText();
    }

    public void dispose() {
        if (this.fCDIExpression != null) {
            try {
                this.fCDIExpression.dispose();
                this.fCDIExpression = null;
            }
            catch (PCDIException pCDIException) {}
        }
        if (this.fValue instanceof AbstractPValue) {
            ((AbstractPValue)this.fValue).dispose();
            this.fValue = PValueFactory.NULL_VALUE;
        }
        this.internalDispose(true);
        this.setDisposed(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPType getType() throws DebugException {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fType == null) {
            PExpression pExpression = this;
            synchronized (pExpression) {
                if (this.fType == null) {
                    this.fType = ((AbstractPValue)this.fValue).getType();
                }
            }
        }
        return this.fType;
    }

    public String getReferenceTypeName() throws DebugException {
        IPType type = this.getType();
        return type != null ? type.getName() : "";
    }
}

