/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariableDescriptor;
import org.eclipse.ptp.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PGlobalVariable;
import org.eclipse.ptp.debug.internal.core.model.PLocalVariable;
import org.eclipse.ptp.debug.internal.core.model.PVariable;

public class PVariableFactory {
    public static PVariable createLocalVariable(PDebugElement parent, IPCDIVariableDescriptor cdiVariableObject) {
        return new PLocalVariable(parent, cdiVariableObject);
    }

    public static PVariable createLocalVariableWithError(PDebugElement parent, IPCDIVariableDescriptor cdiVariableObject, String message) {
        return new PLocalVariable(parent, cdiVariableObject, message);
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(final String name, final IPath path) {
        return new IGlobalVariableDescriptor(){

            public String getName() {
                return name;
            }

            public IPath getPath() {
                return path != null ? path : new Path("");
            }

            public String toString() {
                return MessageFormat.format("{0}::{1}", this.getPath().toOSString(), this.getName());
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof IGlobalVariableDescriptor)) {
                    return false;
                }
                IGlobalVariableDescriptor d = (IGlobalVariableDescriptor)obj;
                return this.getName().compareTo(d.getName()) == 0 && this.getPath().equals((Object)d.getPath());
            }
        };
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(IVariable var) {
        Path path = new Path("");
        ICElement parent = var.getParent();
        if (parent instanceof IBinaryModule) {
            path = ((IBinaryModule)parent).getPath();
        }
        return PVariableFactory.createGlobalVariableDescriptor(var.getElementName(), (IPath)path);
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(IBinaryParser.ISymbol symbol) {
        return PVariableFactory.createGlobalVariableDescriptor(symbol.getName(), symbol.getFilename());
    }

    public static PGlobalVariable createGlobalVariable(PDebugElement parent, IGlobalVariableDescriptor descriptor, IPCDIVariableDescriptor cdiVariableObject) {
        return new PGlobalVariable(parent, descriptor, cdiVariableObject);
    }
}

