/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.debug.core.IPDebugEventListener;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.events.IPDebugEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AbstractPDebugEventHandler
implements IPDebugEventListener {
    private IViewPart fView;

    public AbstractPDebugEventHandler(IViewPart view) {
        this.setView(view);
        PTPDebugCorePlugin.getDefault().addDebugEventListener((IPDebugEventListener)this);
    }

    public void dispose() {
        PTPDebugCorePlugin.getDefault().removeDebugEventListener((IPDebugEventListener)this);
    }

    protected IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public void handleDebugEvent(final IPDebugEvent event) {
        WorkbenchJob uiJob = new WorkbenchJob("Handling Debug Event"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AbstractPDebugEventHandler.this.doHandleDebugEvent(event, monitor);
                AbstractPDebugEventHandler.this.updateForDebugEvent(event, monitor);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(false);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    protected void updateForDebugEvent(IPDebugEvent event, IProgressMonitor monitor) {
    }

    protected abstract void doHandleDebugEvent(IPDebugEvent var1, IProgressMonitor var2);

    protected abstract void refresh(boolean var1);

    public void refresh() {
        this.refresh(false);
    }

    protected IViewPart getView() {
        return this.fView;
    }

    private void setView(IViewPart view) {
        this.fView = view;
    }
}

