/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.events.IPDebugErrorInfo;
import org.eclipse.ptp.debug.core.events.IPDebugEvent;
import org.eclipse.ptp.debug.core.events.IPDebugInfo;
import org.eclipse.ptp.debug.core.events.IPDebugRegisterInfo;
import org.eclipse.ptp.debug.internal.ui.PDebugUIUtils;
import org.eclipse.ptp.debug.internal.ui.UIDebugManager;
import org.eclipse.ptp.debug.internal.ui.views.AbstractPDebugEventHandler;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.views.ParallelDebugView;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ui.IViewPart;

public class ParallelDebugViewEventHandler
extends AbstractPDebugEventHandler {
    public ParallelDebugViewEventHandler(ParallelDebugView view) {
        super((IViewPart)view);
    }

    public ParallelDebugView getPView() {
        return (ParallelDebugView)this.getView();
    }

    public void refresh(boolean all) {
        this.getPView().refresh(all);
    }

    protected void doHandleDebugEvent(IPDebugEvent event, IProgressMonitor monitor) {
        IPDebugInfo info = event.getInfo();
        IPJob job = info.getJob();
        block0 : switch (event.getKind()) {
            case 4: {
                switch (event.getDetail()) {
                    case 1024: {
                        PTPDebugUIPlugin.getUIDebugManager().defaultRegister((IPCDISession)event.getSource());
                        this.refresh();
                        break;
                    }
                    case 2048: {
                        boolean refresh = true;
                        if (info instanceof IPDebugRegisterInfo) {
                            refresh = ((IPDebugRegisterInfo)info).isRefresh();
                        }
                        int[] processes = info.getAllRegisteredProcesses().toArray();
                        if (refresh) {
                            IElementHandler elementHandler = this.getPView().getElementHandler(job.getIDString());
                            if (elementHandler != null) {
                                int j = 0;
                                while (j < processes.length) {
                                    IElement element = elementHandler.getSetRoot().get(String.valueOf(processes[j]));
                                    element.setRegistered(true);
                                    elementHandler.addRegisterElement(element);
                                    ++j;
                                }
                            }
                            this.refresh();
                        }
                        if (processes.length <= 0) break;
                        this.getPView().focusOnDebugTarget(job, processes[0]);
                    }
                }
                break;
            }
            case 8: {
                switch (event.getDetail()) {
                    case 1024: {
                        this.refresh(true);
                        break block0;
                    }
                    case 2048: {
                        boolean refresh = true;
                        if (info instanceof IPDebugRegisterInfo) {
                            refresh = ((IPDebugRegisterInfo)info).isRefresh();
                        }
                        int[] processes = info.getAllUnregisteredProcesses().toArray();
                        if (!refresh) break block0;
                        IElementHandler elementHandler = this.getPView().getElementHandler(job.getIDString());
                        if (elementHandler != null) {
                            int j = 0;
                            while (j < processes.length) {
                                IElement element = elementHandler.getSetRoot().get(String.valueOf(processes[j]));
                                element.setRegistered(false);
                                elementHandler.removeRegisterElement(element);
                                ++j;
                            }
                        }
                        this.refresh();
                        break block0;
                    }
                }
                this.refresh(true);
                break;
            }
            case 1: 
            case 2: {
                if (job.getIDString().equals(this.getPView().getCurrentID())) {
                    ((UIDebugManager)this.getPView().getUIManager()).updateVariableValue(false);
                    if (event.getKind() == 2) {
                        PTPDebugUIPlugin.getUIDebugManager().updateVariableValueOnSuspend();
                    }
                }
                this.getPView().updateAction();
                this.refresh();
                break;
            }
            case 16: {
                this.refresh();
                break;
            }
            case 64: {
                final IPDebugErrorInfo errInfo = (IPDebugErrorInfo)info;
                PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        String msg = "Error on tasks: " + PDebugUIUtils.showBitList(errInfo.getAllProcesses()) + " - " + errInfo.getMsg();
                        Status status = new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, msg, null);
                        PTPDebugUIPlugin.errorDialog("Error", (IStatus)status);
                    }
                });
                this.refresh(true);
            }
        }
    }
}

