/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.AttributeDescription;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDescription;
import org.eclipse.ptp.core.attributes.IMutableAttribute;

public final class MutableDateAttribute
extends AbstractAttribute
implements IMutableAttribute {
    private static DateFormat[] dateFormats = null;
    protected final DateFormat outputDateFormat;
    protected Calendar value;

    public static void main(String[] args) throws IAttribute.IllegalValue {
        Calendar cal = Calendar.getInstance();
        MutableDateAttribute mda = new MutableDateAttribute((IAttributeDescription)new AttributeDescription("name", "desc"), cal);
        System.out.println(mda.toString());
        String str = mda.toString();
        cal.add(2, 2);
        System.out.println(mda.toString());
        mda.setValue(str);
        System.out.println(mda.toString());
    }

    private static DateFormat[] getDateFormats() {
        if (dateFormats != null) {
            return dateFormats;
        }
        Locale[] locals = DateFormat.getAvailableLocales();
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        int[] styles = nArray;
        ArrayList<DateFormat> dfs = new ArrayList<DateFormat>(styles.length * styles.length * locals.length);
        int i = 0;
        while (i < locals.length) {
            int ds = 0;
            while (ds < styles.length) {
                int dateStyle = styles[ds];
                int ts = 0;
                while (ts < styles.length) {
                    int timeStyle = styles[ts];
                    dfs.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle, locals[i]));
                    ++ts;
                }
                ++ds;
            }
            ++i;
        }
        System.out.println("There are " + dfs.size() + " date formats");
        dateFormats = dfs.toArray(new DateFormat[dfs.size()]);
        return dateFormats;
    }

    public MutableDateAttribute(IAttributeDescription description, Calendar value) {
        this(description, value, DateFormat.getDateTimeInstance());
    }

    public MutableDateAttribute(IAttributeDescription description, Calendar value, DateFormat outputDateFormat) {
        super(description);
        this.value = value;
        this.outputDateFormat = outputDateFormat;
    }

    public MutableDateAttribute(IAttributeDescription description, Date date) {
        this(description, date, DateFormat.getDateTimeInstance());
    }

    public MutableDateAttribute(IAttributeDescription description, Date date, DateFormat outputDateFormat) {
        super(description);
        this.outputDateFormat = outputDateFormat;
        this.value = Calendar.getInstance();
        this.value.setTime(date);
    }

    public MutableDateAttribute(IAttributeDescription description, String string) throws IAttribute.IllegalValue {
        super(description);
        this.outputDateFormat = DateFormat.getDateTimeInstance();
        Date date = this.parseString(string);
        if (date == null) {
            throw new IAttribute.IllegalValue("Unable to parse \"" + string + "\" into a date");
        }
        this.value = Calendar.getInstance();
        this.value.setTime(date);
    }

    public IAttribute create(String string) throws IAttribute.IllegalValue {
        return new MutableDateAttribute(this.getDescription(), string);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableDateAttribute) {
            MutableDateAttribute attr = (MutableDateAttribute)obj;
            return this.value.equals(attr.value);
        }
        return false;
    }

    public Calendar getCalendar() {
        return (Calendar)this.value.clone();
    }

    public Date getDate() {
        return this.value.getTime();
    }

    public String getStringRep() {
        return this.outputDateFormat.format(this.value.getTime());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean isValid(String string) {
        Date date = this.parseString(string);
        return date != null;
    }

    public void setValue(String string) throws IAttribute.IllegalValue {
        Date date = this.parseString(string);
        if (date == null) {
            throw new IAttribute.IllegalValue("Unable to parse \"" + string + "\" into a date");
        }
        this.value.setTime(date);
    }

    private Date parseString(String string) {
        Date date = null;
        ParsePosition parsePosition = new ParsePosition(0);
        date = this.outputDateFormat.parse(string, parsePosition);
        if (date != null) {
            return date;
        }
        int i = 0;
        while (i < MutableDateAttribute.getDateFormats().length) {
            parsePosition.setIndex(0);
            date = MutableDateAttribute.getDateFormats()[i].parse(string, parsePosition);
            if (date != null) {
                return date;
            }
            ++i;
        }
        return date;
    }

    protected int doCompareTo(AbstractAttribute arg0) {
        MutableDateAttribute da = (MutableDateAttribute)arg0;
        return this.value.compareTo(da.value);
    }
}

