/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.core.proxy.event.IProxyEvent;
import org.eclipse.ptp.core.proxy.event.IProxyEventListener;
import org.eclipse.ptp.core.proxy.event.ProxyConnectedEvent;
import org.eclipse.ptp.core.proxy.event.ProxyDisconnectedEvent;
import org.eclipse.ptp.core.proxy.event.ProxyEvent;
import org.eclipse.ptp.core.proxy.event.ProxyOKEvent;
import org.eclipse.ptp.core.proxy.event.ProxyTimeoutEvent;
import org.eclipse.ptp.core.util.BitList;

public abstract class AbstractProxyClient {
    private String sessHost = null;
    private int sessPort = 0;
    private ServerSocketChannel sessSvrSock = null;
    private SocketChannel sessSock = null;
    private boolean sessConnected = false;
    private boolean exitThread;
    private Thread eventThread;
    private Thread acceptThread;
    protected List listeners = Collections.synchronizedList(new ArrayList());
    private static Charset charset = Charset.forName("US-ASCII");
    private static CharsetEncoder encoder = charset.newEncoder();
    private static CharsetDecoder decoder = charset.newDecoder();
    private boolean shutting_down = false;
    private boolean have_shut_down = false;

    private String encodeLength(int val) {
        char[] res = new char[8];
        String str = Integer.toHexString(val);
        int rem = 8 - str.length();
        int i = 0;
        while (i < 8) {
            res[i] = i < rem ? 48 : str.charAt(i - rem);
            ++i;
        }
        return String.valueOf(res);
    }

    public static String encodeString(String str) {
        if (str == null || str.length() == 0) {
            return "1:00";
        }
        byte[] b = str.getBytes();
        String res = String.valueOf(Integer.toHexString(str.length() + 1)) + ":";
        int i = 0;
        while (i < b.length) {
            if (b[i] < 10) {
                res = String.valueOf(res) + "0";
            }
            res = String.valueOf(res) + Integer.toHexString(b[i]);
            ++i;
        }
        return String.valueOf(res) + "00";
    }

    protected String encodeBitSet(BitList set) {
        String lenStr = Integer.toHexString(set.size());
        return String.valueOf(lenStr) + ":" + set.toString();
    }

    protected void sendCommand(String cmd) throws IOException {
        if (!this.sessConnected) {
            throw new IOException("Session is not connected");
        }
        String buf = String.valueOf(this.encodeLength(cmd.length())) + " " + cmd;
        System.out.println("<" + buf + ">");
        this.fullWrite(encoder.encode(CharBuffer.wrap(buf)));
    }

    protected void sendCommand(String cmd, String arg1) throws IOException {
        this.sendCommand(String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(arg1));
    }

    protected void sendCommand(String cmd, String arg1, String arg2) throws IOException {
        this.sendCommand(String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(arg1) + " " + AbstractProxyClient.encodeString(arg2));
    }

    protected void sendCommand(String cmd, String arg1, String arg2, String arg3) throws IOException {
        this.sendCommand(String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(arg1) + " " + AbstractProxyClient.encodeString(arg2) + " " + AbstractProxyClient.encodeString(arg3));
    }

    protected void sendCommand(String cmd, String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            cmd = String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(args[i]);
            ++i;
        }
        this.sendCommand(cmd);
    }

    protected void sendCommand(String cmd, String arg1, String[] args) throws IOException {
        cmd = String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(arg1);
        int i = 0;
        while (i < args.length) {
            cmd = String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(args[i]);
            ++i;
        }
        this.sendCommand(cmd);
    }

    protected void sendCommand(String cmd, String arg1, String arg2, String[] args) throws IOException {
        cmd = String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(arg1) + " " + AbstractProxyClient.encodeString(arg2);
        int i = 0;
        while (i < args.length) {
            cmd = String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(args[i]);
            ++i;
        }
        this.sendCommand(cmd);
    }

    protected void sendCommand(String cmd, String arg1, String arg2, String arg3, String[] args) throws IOException {
        cmd = String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(arg1) + " " + AbstractProxyClient.encodeString(arg2) + " " + AbstractProxyClient.encodeString(arg3);
        int i = 0;
        while (i < args.length) {
            cmd = String.valueOf(cmd) + " " + AbstractProxyClient.encodeString(args[i]);
            ++i;
        }
        this.sendCommand(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(IProxyEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(IProxyEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public int sessionConnect() {
        return 0;
    }

    public void sessionCreate() throws IOException {
        this.sessionCreate(0);
    }

    public void sessionCreate(int timeout) throws IOException {
        this.sessionCreate(0, timeout);
    }

    public void sessionCreate(int port, int timeout) throws IOException {
        System.out.println("sessionCreate(" + port + "," + timeout + ")");
        this.sessSvrSock = ServerSocketChannel.open();
        InetSocketAddress isa = new InetSocketAddress(port);
        System.out.println("bind(" + isa.toString() + ")");
        this.sessSvrSock.socket().bind(isa);
        if (timeout > 0) {
            this.sessSvrSock.socket().setSoTimeout(timeout);
        }
        this.sessPort = this.sessSvrSock.socket().getLocalPort();
        this.sessHost = this.sessSvrSock.socket().getLocalSocketAddress().toString();
        System.out.println("port=" + this.sessPort);
        this.acceptThread = new Thread("Proxy Client Accept Thread"){

            public void run() {
                try {
                    System.out.println("accept thread starting...");
                    AbstractProxyClient.this.sessSock = AbstractProxyClient.this.sessSvrSock.accept();
                    AbstractProxyClient.this.sessConnected = true;
                    AbstractProxyClient.this.fireProxyEvent(new ProxyConnectedEvent());
                    AbstractProxyClient.this.startEventThread();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    AbstractProxyClient.this.fireProxyEvent(new ProxyTimeoutEvent());
                }
                catch (IOException iOException) {
                    System.out.println("accept failed... :(");
                }
                try {
                    AbstractProxyClient.this.sessSvrSock.close();
                }
                catch (IOException iOException) {
                    System.out.println("accept thread IO Exception");
                }
                System.out.println("accept thread exiting...");
            }
        };
        this.acceptThread.start();
    }

    public int getSessionPort() {
        return this.sessPort;
    }

    public String getSessionHost() {
        return this.sessHost;
    }

    private void startEventThread() throws IOException {
        this.eventThread = new Thread("Proxy Client Event Thread"){

            public void run() {
                System.out.println("event thread starting...");
                try {
                    AbstractProxyClient.this.exitThread = false;
                    while (!AbstractProxyClient.this.exitThread && !AbstractProxyClient.this.query_have_shut_down()) {
                        AbstractProxyClient.this.sessionProgress();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("event thread IOException . . .");
                }
                AbstractProxyClient.this.sessConnected = false;
                try {
                    AbstractProxyClient.this.sessSock.close();
                }
                catch (IOException iOException) {
                    System.out.println("event thread IOException . . .");
                }
                System.out.println("event thread exiting...");
                AbstractProxyClient.this.fireProxyEvent(new ProxyDisconnectedEvent(!AbstractProxyClient.this.query_have_shut_down()));
            }
        };
        this.eventThread.start();
    }

    protected synchronized boolean query_have_shut_down() {
        return this.have_shut_down;
    }

    private synchronized void set_have_shut_down(boolean state) {
        this.have_shut_down = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProxyEvent(IProxyEvent event) {
        if (this.shutting_down && event instanceof ProxyOKEvent) {
            this.set_have_shut_down(true);
        }
        if (this.listeners == null) {
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            for (IProxyEventListener listener : this.listeners) {
                listener.handleEvent(event);
            }
        }
    }

    private boolean fullRead(ByteBuffer buf) throws IOException {
        buf.clear();
        while (buf.remaining() > 0) {
            int n = this.sessSock.read(buf);
            if (n >= 0) continue;
            return false;
        }
        buf.flip();
        return true;
    }

    private boolean fullWrite(ByteBuffer buf) throws IOException {
        while (buf.remaining() > 0) {
            int n = this.sessSock.write(buf);
            if (n >= 0) continue;
            return false;
        }
        return true;
    }

    private void sessionProgress() throws IOException {
        ByteBuffer len_bytes = ByteBuffer.allocate(9);
        if (!this.fullRead(len_bytes)) {
            this.exitThread = true;
            return;
        }
        CharBuffer len_str = decoder.decode(len_bytes);
        int len = Integer.parseInt(len_str.subSequence(0, 8).toString(), 16);
        ByteBuffer event_bytes = ByteBuffer.allocate(len);
        if (!this.fullRead(event_bytes)) {
            this.exitThread = true;
            return;
        }
        CharBuffer event_str = decoder.decode(event_bytes);
        this.fireProxyEvent(ProxyEvent.toEvent(event_str.toString()));
    }

    public void sessionFinish() throws IOException {
        try {
            this.sendCommand("QUI");
        }
        finally {
            this.shutting_down = true;
            if (this.acceptThread.isAlive()) {
                this.acceptThread.interrupt();
            }
        }
    }
}

