/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.HashMap;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.core.PElementInfo;
import org.eclipse.ptp.internal.core.elementcontrols.IPElementControl;

public abstract class PElement
extends PlatformObject
implements IPElementControl,
Comparable {
    protected HashMap[] attribClass = new HashMap[7];
    protected HashMap elementAttribs = new HashMap();
    protected int ID = PTPCorePlugin.getDefault().getNewID();
    private PElementInfo elementInfo = null;

    protected PElement(IPElementControl parent, String name, String key, int type) {
        this.elementAttribs.put("ATTRIB_PARENT", parent);
        this.elementAttribs.put("ATTRIB_NAME", name);
        this.elementAttribs.put("ATTRIB_TYPE", new Integer(type));
        this.attribClass[0] = this.elementAttribs;
    }

    protected PElementInfo getElementInfo() {
        if (this.elementInfo == null) {
            this.elementInfo = new PElementInfo(this);
        }
        return this.elementInfo;
    }

    public Object getAttribute(int attr_class, String key) {
        if (attr_class < 0 || attr_class >= 7) {
            return null;
        }
        HashMap attribs = this.attribClass[attr_class];
        if (attribs == null) {
            return null;
        }
        return attribs.get(key);
    }

    public void setAttribute(int attr_class, String key, Object o) {
        if (attr_class < 0 || attr_class >= 7) {
            return;
        }
        HashMap<String, Object> attribs = this.attribClass[attr_class];
        if (attribs == null) {
            attribs = new HashMap<String, Object>();
        }
        attribs.put(key, o);
        this.attribClass[attr_class] = attribs;
    }

    public String[] getAttributeKeys(int attr_class) {
        if (attr_class < 0 || attr_class >= 7) {
            return new String[0];
        }
        HashMap attribs = this.attribClass[attr_class];
        if (attribs == null) {
            return new String[0];
        }
        return attribs.keySet().toArray(new String[0]);
    }

    public String getElementName() {
        return (String)this.elementAttribs.get("ATTRIB_NAME");
    }

    public int getID() {
        return this.ID;
    }

    public String getIDString() {
        return "" + this.ID;
    }

    public void setElementName(String name) {
        this.elementAttribs.put("ATTRIB_NAME", name);
    }

    public IPElementControl getParent() {
        return (IPElementControl)this.elementAttribs.get("ATTRIB_PARENT");
    }

    public void setParent(IPElementControl parent) {
        this.elementAttribs.put("ATTRIB_PARENT", parent);
    }

    public int getElementType() {
        Integer i = (Integer)this.elementAttribs.get("ATTRIB_TYPE");
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setElementType(int type) {
        this.elementAttribs.put("ATTRIB_TYPE", new Integer(type));
    }

    public String toString() {
        return this.getElementName();
    }

    public int size() {
        return this.getElementInfo().size();
    }

    public int compareTo(Object obj) {
        if (obj instanceof IPElementControl) {
            int his_rank;
            int my_rank = this.getID();
            if (my_rank < (his_rank = ((IPElementControl)obj).getID())) {
                return -1;
            }
            if (my_rank == his_rank) {
                return 0;
            }
            if (my_rank > his_rank) {
                return 1;
            }
        }
        return 0;
    }

    public int computeScore(String pageId, Object element) {
        if (element instanceof IPElementControl) {
            return 90;
        }
        return 0;
    }
}

