/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.internal.core.Parent;
import org.eclipse.ptp.internal.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPUniverseControl;

public class PUniverse
extends Parent
implements IPUniverseControl {
    protected String NAME_TAG = "universe ";

    public PUniverse() {
        super(null, "TheUniverse", "1", 10);
    }

    public synchronized IPMachine[] getMachines() {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        Vector<IPMachineControl> m = new Vector<IPMachineControl>();
        while (it.hasNext()) {
            Object ob = it.next();
            if (!(ob instanceof IPMachineControl)) continue;
            m.add((IPMachineControl)ob);
        }
        IPMachine[] mac = m.toArray(new IPMachineControl[0]);
        return mac;
    }

    public synchronized IPMachine[] getSortedMachines() {
        IPElementControl[] macs = (IPMachineControl[])this.getMachines();
        this.sort(macs);
        return macs;
    }

    public synchronized IPMachine findMachineByName(String mname) {
        Collection col = this.getCollection();
        for (Object ob : col) {
            IPMachine mac;
            if (!(ob instanceof IPMachine) || !(mac = (IPMachine)ob).getName().equals(mname)) continue;
            return mac;
        }
        return null;
    }

    public synchronized IPMachine findMachineById(String machine_id) {
        Collection col = this.getCollection();
        for (Object ob : col) {
            IPMachine mac;
            if (!(ob instanceof IPMachine) || !(mac = (IPMachine)ob).getMachineId().equals(machine_id)) continue;
            return mac;
        }
        return null;
    }

    public synchronized IPMachine findMachineByGlobalId(String machine_id) {
        Collection col = this.getCollection();
        for (Object ob : col) {
            IPMachine mac;
            if (!(ob instanceof IPMachine) || !(mac = (IPMachine)ob).getIDString().equals(machine_id)) continue;
            return mac;
        }
        return null;
    }

    public synchronized IPJob[] getJobs() {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        Vector<IPJobControl> m = new Vector<IPJobControl>();
        while (it.hasNext()) {
            Object ob = it.next();
            if (!(ob instanceof IPJobControl)) continue;
            m.add((IPJobControl)ob);
        }
        Object[] o = m.toArray();
        IPJob[] job = new IPJobControl[o.length];
        int i = 0;
        while (i < o.length) {
            job[i] = (IPJobControl)o[i];
            ++i;
        }
        return job;
    }

    public synchronized IPJob[] getSortedJobs() {
        IPElementControl[] jobs = (IPJobControl[])this.getJobs();
        this.sort(jobs);
        return jobs;
    }

    public synchronized IPJob findJobByName(String jname) {
        Collection col = this.getCollection();
        for (Object ob : col) {
            IPJobControl job;
            if (!(ob instanceof IPJobControl) || !(job = (IPJobControl)ob).getElementName().equals(jname)) continue;
            return job;
        }
        return null;
    }

    public synchronized IPJob findJobById(String job_id) {
        IPElementControl element = this.findChild(job_id);
        if (element instanceof IPJobControl) {
            return (IPJobControl)element;
        }
        return null;
    }

    public synchronized IPProcess findProcessByName(String pname) {
        Collection col = this.getCollection();
        for (Object ob : col) {
            IPProcess proc;
            if (!(ob instanceof IPJob) || (proc = ((IPJob)ob).findProcessByName(pname)) == null) continue;
            return proc;
        }
        return null;
    }

    public void deleteJob(IPJob jobIn) {
        IPJobControl job = (IPJobControl)jobIn;
        for (IPProcessControl process : job.getCollection()) {
            IPNodeControl node;
            if (process == null || (node = (IPNodeControl)process.getNode()) == null) continue;
            node.removeChild(process);
        }
        job.removeAllProcesses();
        this.removeChild(job);
    }
}

