/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rmsystem;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.IModelListener;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.IModelPresentation;
import org.eclipse.ptp.core.events.IModelEvent;
import org.eclipse.ptp.core.events.IModelRuntimeNotifierEvent;
import org.eclipse.ptp.core.events.IModelSysChangedEvent;
import org.eclipse.ptp.internal.rmsystem.NullManager;
import org.eclipse.ptp.rmsystem.AbstractResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.ResourceManagerStatus;
import org.eclipse.ptp.rtsystem.IControlSystem;

public class ModelManagerResourceManager
extends AbstractResourceManager
implements IModelListener {
    private static final NullManager NULL_MANAGER = new NullManager();
    private final IModelManager manager;

    public ModelManagerResourceManager(IModelManager manager, IResourceManagerConfiguration config) {
        super(config);
        this.manager = manager;
        manager.addModelListener(this);
    }

    protected void doStart() throws CoreException {
    }

    protected void doStop() throws CoreException {
        this.manager.shutdown();
    }

    public IControlSystem getControlSystem() {
        return this.manager.getControlSystem();
    }

    public IModelPresentation getModelPresentation() {
        return this.manager;
    }

    public IModelManager getModelManager() {
        return this.manager;
    }

    public void modelEvent(IModelEvent event) {
        if (event instanceof IModelRuntimeNotifierEvent) {
            IModelRuntimeNotifierEvent runtimeEvent = (IModelRuntimeNotifierEvent)event;
            int eventType = runtimeEvent.getType();
            switch (runtimeEvent.getStatus()) {
                case 0: {
                    this.setStatus(ResourceManagerStatus.STARTED, false);
                    break;
                }
                case 1: {
                    this.setStatus(ResourceManagerStatus.STARTED, false);
                }
            }
            if (eventType == 2) {
                switch (runtimeEvent.getStatus()) {
                    case 3: {
                        this.manager.removeModelListener(this);
                        this.setStatus(ResourceManagerStatus.STOPPED, false);
                        break;
                    }
                    case 2: {
                        this.manager.removeModelListener(this);
                        this.setStatus(ResourceManagerStatus.STOPPED, false);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (event instanceof IModelSysChangedEvent) {
            IModelSysChangedEvent sysEvent = (IModelSysChangedEvent)event;
            switch (sysEvent.getType()) {
                case 0: {
                    this.setStatus(ResourceManagerStatus.STARTED, false);
                    break;
                }
            }
        }
    }
}

