/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import java.util.Arrays;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.Messages;
import org.eclipse.ptp.rmsystem.SimulationResourceManagerFactory;
import org.eclipse.ui.IMemento;

public class SimulationRMConfiguration
implements IResourceManagerConfiguration {
    private static final String TAG_NUM_NODES = "numNodes";
    private static final String TAG_MACHINE = "machine";
    private static final String TAG_NUM_MACHINES = "numMachines";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_NAME = "name";
    private static final String TAG_FACTORY_ID = "factoryId";
    private String description;
    private String name;
    private final String factoryId;
    private int numMachines = -1;
    private int[] numNodesPerMachines = null;

    public static SimulationRMConfiguration load(SimulationResourceManagerFactory factory, IMemento memento) {
        String factoryId = memento.getString(TAG_FACTORY_ID);
        if (!factoryId.equals(factory.getId())) {
            throw new IllegalStateException(String.valueOf(Messages.getString("SimulationRMConfiguration.IncompatableFactoryID")) + Messages.getString("SimulationRMConfiguration.StoredId") + factoryId + Messages.getString("SimulationRMConfiguration.ExpectedFactoryId") + factory.getId());
        }
        String name = memento.getString(TAG_NAME);
        String desc = memento.getString(TAG_DESCRIPTION);
        Integer integerNumMachines = memento.getInteger(TAG_NUM_MACHINES);
        int numMachines = integerNumMachines == null ? 0 : integerNumMachines;
        int[] numNodesPerMachine = new int[numMachines];
        IMemento[] machineChildren = memento.getChildren(TAG_MACHINE);
        if (machineChildren.length != numMachines) {
            throw new RuntimeException(Messages.getString("SimulationRMConfiguration.IncorrectNumMachines"));
        }
        int i = 0;
        while (i < numMachines) {
            numNodesPerMachine[i] = machineChildren[i].getInteger(TAG_NUM_NODES);
            ++i;
        }
        SimulationRMConfiguration config = new SimulationRMConfiguration(factory, name, desc, numMachines, numNodesPerMachine);
        return config;
    }

    public SimulationRMConfiguration(SimulationResourceManagerFactory factory, String name, String desc) {
        this.factoryId = factory.getId();
        this.name = name;
        this.description = desc;
    }

    public SimulationRMConfiguration(SimulationResourceManagerFactory factory, String name, String desc, int numMachines, int[] numNodesPerMachine) {
        this(factory, name, desc);
        this.numMachines = numMachines;
        this.numNodesPerMachines = numNodesPerMachine;
        if (numNodesPerMachine.length != numMachines) {
            throw new IllegalArgumentException(Messages.getString("SimulationRMConfiguration.NumNodesPerMachineLength"));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getNumMachines() {
        return this.numMachines;
    }

    public int getNumNodesPerMachine(int i) {
        return this.numNodesPerMachines[i];
    }

    public int[] getNumNodesPerMachines() {
        return (int[])this.numNodesPerMachines.clone();
    }

    public String getResourceManagerId() {
        return this.factoryId;
    }

    public void save(IMemento memento) {
        memento.putString(TAG_FACTORY_ID, this.getResourceManagerId());
        memento.putString(TAG_NAME, this.name);
        memento.putString(TAG_DESCRIPTION, this.description);
        memento.putInteger(TAG_NUM_MACHINES, this.numMachines);
        int i = 0;
        while (i < this.numMachines) {
            IMemento child = memento.createChild(TAG_MACHINE);
            child.putInteger(TAG_NUM_NODES, this.numNodesPerMachines[i]);
            ++i;
        }
    }

    public void setNumMachines(int nm) {
        this.numMachines = nm;
        this.numNodesPerMachines = new int[nm >= 0 ? nm : 0];
        Arrays.fill(this.numNodesPerMachines, 0);
    }

    public void setNumNodesPerMachine(int whichMachine, int value) {
        this.numNodesPerMachines[whichMachine] = value;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultNameAndDesc() {
        String name = Messages.getString("SimulationResourceManagerFactory.DefaultRMName");
        String description = Messages.getString("SimulationResourceManagerFactory.DefaultRMDescription");
        String machinesLabel = Messages.getString("SimulationRMConfiguration.Machines");
        machinesLabel = " (" + Integer.toString(this.numMachines) + machinesLabel + ")";
        this.name = String.valueOf(name) + machinesLabel;
        this.description = String.valueOf(description) + machinesLabel;
    }
}

