/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.core.ModelManager;
import org.eclipse.ptp.internal.rmsystem.ModelManagerResourceManager;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerFactory;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.Messages;
import org.eclipse.ptp.rmsystem.SimulationRMConfiguration;
import org.eclipse.ui.IMemento;

public class SimulationResourceManagerFactory
extends AbstractResourceManagerFactory {
    public SimulationResourceManagerFactory() {
        super(Messages.getString("SimulationResourceManagerFactory.ResourceManagerFactoryName"));
    }

    public IResourceManager create(IResourceManagerConfiguration confIn) {
        SimulationRMConfiguration configuration = (SimulationRMConfiguration)confIn;
        Preferences p = PTPCorePlugin.getDefault().getPluginPreferences();
        p.setValue("DEVELOPER_MODE", true);
        PTPCorePlugin.getDefault().savePluginPreferences();
        ModelManager manager = new ModelManager(configuration.getNumMachines(), configuration.getNumNodesPerMachines());
        return new ModelManagerResourceManager(manager, configuration);
    }

    public IResourceManagerConfiguration createConfiguration() {
        String name = Messages.getString("SimulationResourceManagerFactory.DefaultRMName");
        String description = Messages.getString("SimulationResourceManagerFactory.DefaultRMDescription");
        SimulationRMConfiguration config = new SimulationRMConfiguration(this, name, description);
        return config;
    }

    public IResourceManagerConfiguration loadConfiguration(IMemento memento) {
        return SimulationRMConfiguration.load(this, memento);
    }
}

