/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.simulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.rtsystem.IMonitoringSystem;
import org.eclipse.ptp.rtsystem.IRuntimeListener;
import org.eclipse.ptp.rtsystem.event.RuntimeNodeGeneralChangedEvent;

public class SimulationMonitoringSystem
implements IMonitoringSystem {
    protected List<IRuntimeListener> listeners = new ArrayList<IRuntimeListener>(2);
    protected HashMap<String, Integer> nodeMap;
    protected HashMap<String, String> nodeUserMap;
    protected HashMap<String, String> nodeGroupMap;
    protected HashMap<String, String> nodeModeMap;
    protected HashMap<String, String> nodeStateMap;
    protected int numMachines = 1;
    protected int[] numNodes;

    public SimulationMonitoringSystem(int numMachines, int[] numNodes) {
        System.out.println("User selected " + numMachines + " simulated machines.");
        if (numMachines < 1) {
            this.numMachines = 1;
            System.err.println("No existing / invalid number of machines to to simulate detected.  Default number of machines set to 1.  Set using the PTP preferences -> simulation page.");
            numNodes = new int[]{256};
        } else {
            if (numMachines != numNodes.length) {
                throw new IllegalArgumentException("the array numNodes must be of length numMachines");
            }
            int i = 0;
            while (i < numMachines) {
                System.out.println("SimPreferences: Machine " + i + " = " + numNodes[i] + " nodes");
                ++i;
            }
        }
        this.numMachines = numMachines;
        this.numNodes = (int[])numNodes.clone();
    }

    public void startup() {
        this.nodeMap = new HashMap();
        int i = 0;
        while (i < this.numMachines) {
            String s = new String("machine" + i);
            this.nodeMap.put(s, new Integer(this.numNodes[i]));
            ++i;
        }
        int totnodes = 0;
        int i2 = 0;
        while (i2 < this.numMachines) {
            totnodes += this.numNodes[i2];
            ++i2;
        }
        this.nodeUserMap = new HashMap();
        this.nodeGroupMap = new HashMap();
        this.nodeModeMap = new HashMap();
        this.nodeStateMap = new HashMap();
        if (this.numMachines >= 4) {
            i2 = 0;
            while (i2 < this.numNodes[3]) {
                String s = new String("machine3_node" + i2);
                int r = (int)(Math.random() * 100.0);
                if (r < 10) {
                    this.nodeStateMap.put(s, new String("error"));
                } else if (r < 30) {
                    this.nodeStateMap.put(s, new String("down"));
                } else {
                    this.nodeStateMap.put(s, new String("up"));
                }
                ++i2;
            }
            int nstart = (int)(Math.random() * 50.0);
            int nlen = (int)(Math.random() * 40.0 + 10.0);
            String nmode = new String((int)(Math.random() * 2.0) == 0 ? "73" : "64");
            int gstart = (int)(Math.random() * 50.0 + (double)(nstart + nlen));
            int glen = (int)(Math.random() * 100.0 + 40.0);
            String gmode = new String((int)(Math.random() * 2.0) == 0 ? "73" : "64");
            int cstart = (int)(Math.random() * 50.0 + (double)(nstart + nlen + gstart + glen));
            int clen = (int)(Math.random() * 75.0 + 25.0);
            String cmode = new String((int)(Math.random() * 2.0) == 0 ? "73" : "64");
            int i3 = 0;
            while (i3 < this.numNodes[3]) {
                String s = new String("machine3_node" + i3);
                if (i3 >= nstart && i3 <= nstart + nlen) {
                    this.nodeUserMap.put(s, new String(System.getProperty("user.name")));
                    this.nodeGroupMap.put(s, new String("ptp"));
                    this.nodeModeMap.put(s, nmode);
                } else if (i3 >= gstart && i3 <= gstart + glen) {
                    this.nodeUserMap.put(s, new String("gwatson"));
                    this.nodeGroupMap.put(s, new String("ptp"));
                    this.nodeModeMap.put(s, gmode);
                } else if (i3 >= cstart && i3 <= cstart + clen) {
                    this.nodeUserMap.put(s, new String("crasmussen"));
                    this.nodeGroupMap.put(s, new String("ptp"));
                    this.nodeModeMap.put(s, cmode);
                } else {
                    this.nodeUserMap.put(s, new String(""));
                    this.nodeGroupMap.put(s, new String(""));
                    this.nodeModeMap.put(s, new String("73"));
                }
                ++i3;
            }
        }
        if (this.numMachines >= 1) {
            i2 = 0;
            while (i2 < this.numNodes[0]) {
                String s = new String("machine0_node" + i2);
                this.nodeStateMap.put(s, new String("up"));
                this.nodeUserMap.put(s, new String(System.getProperty("user.name")));
                this.nodeGroupMap.put(s, new String("ptp"));
                this.nodeModeMap.put(s, new String("64"));
                ++i2;
            }
        }
        if (this.numMachines >= 2) {
            i2 = 0;
            while (i2 < this.numNodes[1]) {
                String s = new String("machine1_node" + i2);
                this.nodeStateMap.put(s, new String("up"));
                if (i2 < 32) {
                    this.nodeUserMap.put(s, new String(System.getProperty("user.name")));
                    this.nodeGroupMap.put(s, new String("ptp"));
                    this.nodeModeMap.put(s, new String("64"));
                } else if (i2 < 64) {
                    this.nodeUserMap.put(s, new String(""));
                    this.nodeGroupMap.put(s, new String(""));
                    this.nodeModeMap.put(s, new String("73"));
                } else if (i2 < 128) {
                    this.nodeUserMap.put(s, new String("wjones"));
                    this.nodeGroupMap.put(s, new String("parl"));
                    this.nodeModeMap.put(s, new String("64"));
                } else {
                    this.nodeUserMap.put(s, new String("jsmith"));
                    this.nodeGroupMap.put(s, new String("awhere"));
                    this.nodeModeMap.put(s, new String("73"));
                }
                ++i2;
            }
        }
        if (this.numMachines >= 3) {
            i2 = 0;
            while (i2 < this.numNodes[2]) {
                String s = new String("machine2_node" + i2);
                int r = (int)(Math.random() * 100.0);
                if (r < 3) {
                    this.nodeStateMap.put(s, new String("error"));
                } else if (r < 6) {
                    this.nodeStateMap.put(s, new String("down"));
                } else {
                    this.nodeStateMap.put(s, new String("up"));
                    this.nodeUserMap.put(s, new String(System.getProperty("user.name")));
                    this.nodeGroupMap.put(s, new String("ptp"));
                    this.nodeModeMap.put(s, new String("64"));
                }
                ++i2;
            }
        }
        i2 = 4;
        while (i2 < this.numMachines) {
            int j = 0;
            while (j < this.numNodes[i2]) {
                String s = new String("machine" + i2 + "_node" + j);
                this.nodeStateMap.put(s, new String("up"));
                this.nodeUserMap.put(s, new String(System.getProperty("user.name")));
                this.nodeGroupMap.put(s, new String("ptp"));
                this.nodeModeMap.put(s, new String("64"));
                ++j;
            }
            ++i2;
        }
    }

    public void shutdown() {
        this.listeners.clear();
        this.listeners = null;
    }

    public void addRuntimeListener(IRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeRuntimeListener(IRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    public String[] getMachines() {
        int i = 0;
        Set<String> set = this.nodeMap.keySet();
        Object[] arset = set.toArray();
        Arrays.sort(arset);
        String[] ne = new String[arset.length];
        i = 0;
        while (i < arset.length) {
            ne[i] = new String((String)arset[i]);
            ++i;
        }
        return ne;
    }

    public String[] getNodes(IPMachine machine) {
        String machineName = machine.getName();
        if (!this.nodeMap.containsKey(machineName)) {
            return null;
        }
        int n = this.nodeMap.get(machineName);
        String[] ne = new String[n];
        int i = 0;
        while (i < ne.length) {
            ne[i] = new String(String.valueOf(machineName) + "_node" + i);
            ++i;
        }
        return ne;
    }

    public String getNodeMachineName(String nodeName) {
        int idx = nodeName.indexOf("_");
        if (idx >= 0) {
            return nodeName.substring(0, idx);
        }
        return "";
    }

    public String[] getNodeAttributes(IPNode node, String[] attribs) {
        String nodeName = node.getName();
        String[] retstr = new String[attribs.length];
        int i = 0;
        while (i < attribs.length) {
            String attrib = attribs[i];
            String s = null;
            if (attrib.equals("Node Name")) {
                s = nodeName;
            } else if (attrib.equals("Status")) {
                s = this.nodeStateMap.get(nodeName);
            } else if (attrib.equals("Mode")) {
                s = this.nodeModeMap.get(nodeName);
            } else if (attrib.equals("User Owner")) {
                s = this.nodeUserMap.get(nodeName);
            } else if (attrib.equals("Group Owner")) {
                s = this.nodeGroupMap.get(nodeName);
            }
            retstr[i] = new String(s != null ? s : "");
            ++i;
        }
        return retstr;
    }

    public String[] getAllNodesAttributes(IPMachine machine, String[] attribs) {
        IPNode[] nodes = machine.getSortedNodes();
        String[] allvals = new String[attribs.length * nodes.length];
        int i = 0;
        while (i < nodes.length) {
            String[] nvals = this.getNodeAttributes(nodes[i], attribs);
            int j = 0;
            while (j < nvals.length) {
                allvals[i * nvals.length + j] = new String(nvals[j]);
                ++j;
            }
            ++i;
        }
        return allvals;
    }

    public void initiateDiscovery() throws CoreException {
        String[] machines = this.getMachines();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int im = 0;
        while (im < machines.length) {
            keys.add("Machine ID");
            values.add(machines[im]);
            int in = 0;
            while (in < this.numNodes[im]) {
                keys.add("Node Number");
                values.add(Integer.toString(in));
                ++in;
            }
            ++im;
        }
        this.fireEvent(keys.toArray(new String[0]), values.toArray(new String[0]));
    }

    private void fireEvent(String[] keys, String[] values) {
        ArrayList<IRuntimeListener> listeners2 = new ArrayList<IRuntimeListener>(this.listeners);
        RuntimeNodeGeneralChangedEvent event = new RuntimeNodeGeneralChangedEvent(keys, values);
        for (IRuntimeListener l : listeners2) {
            l.performRuntimeEvent(event);
        }
    }
}

