/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.text.MessageFormat;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.AbstractParallelLaunchConfigurationDelegate;
import org.eclipse.ptp.launch.internal.RuntimeProcess;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public class ParallelLaunchConfigurationDelegate
extends AbstractParallelLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!(launch instanceof IPLaunch)) {
            this.abort(LaunchMessages.getResourceString("ParallelLaunchConfigurationDelegate.Invalid_launch_object"), null, 0);
        }
        IPLaunch pLaunch = (IPLaunch)launch;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("run")) {
            this.runtimeApplication(configuration, pLaunch, monitor);
        }
        if (mode.equals("debug")) {
            this.launchDebugger(configuration, pLaunch, monitor);
        }
    }

    private void runtimeApplication(ILaunchConfiguration configuration, IPLaunch pLaunch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 250);
        monitor.setTaskName(MessageFormat.format("{0} . . .", "Runtime Applicatoin Launching " + configuration.getName()));
        if (monitor.isCanceled()) {
            return;
        }
        JobRunConfiguration jrunconfig = this.getJobRunConfiguration(configuration);
        PTPDebugUIPlugin.getDefault().getPreferenceStore();
        monitor.worked(10);
        monitor.subTask("Starting the job . . .");
        IPJob job = this.getLaunchManager().run((ILaunch)pLaunch, jrunconfig, (IProgressMonitor)new SubProgressMonitor(monitor, 150));
        pLaunch.setAttribute("JOB_ID", job.getIDString());
        new RuntimeProcess(pLaunch, job, null);
        monitor.done();
    }

    private void launchDebugger(ILaunchConfiguration configuration, IPLaunch pLaunch, IProgressMonitor monitor) throws CoreException {
        String dbgExtraArgs;
        monitor.beginTask("", 250);
        monitor.setTaskName(MessageFormat.format("{0} . . .", "Launching Debugger" + configuration.getName()));
        if (monitor.isCanceled()) {
            return;
        }
        JobRunConfiguration jrunconfig = this.getJobRunConfiguration(configuration);
        IPreferenceStore store = PTPDebugUIPlugin.getDefault().getPreferenceStore();
        monitor.subTask("Configuring debug setting . . .");
        String dbgFile = store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_FILE);
        String dbgArgs = "--host=" + store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_HOST);
        dbgArgs = String.valueOf(dbgArgs) + " --debugger=" + store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND);
        String dbgPath = store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND_PATH);
        if (dbgPath.length() > 0) {
            dbgArgs = String.valueOf(dbgArgs) + " --debugger_path=" + dbgPath;
        }
        if ((dbgExtraArgs = store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_ARGS)).length() > 0) {
            dbgArgs = String.valueOf(dbgArgs) + " " + dbgExtraArgs;
        }
        this.verifyDebuggerPath(dbgFile);
        IPDebugConfiguration debugConfig = this.getDebugConfig(configuration);
        IAbstractDebugger debugger = debugConfig.createDebugger();
        jrunconfig.setDebuggerPath(dbgFile);
        dbgArgs = String.valueOf(dbgArgs) + " --port=" + debugger.getDebuggerPort();
        jrunconfig.setDebuggerArgs(dbgArgs);
        jrunconfig.setDebug();
        monitor.worked(10);
        monitor.subTask("Starting the job . . .");
        IBinaryParser.IBinaryObject exeFile = this.verifyBinary(configuration);
        this.setDefaultSourceLocator((ILaunch)pLaunch, configuration);
        int timeout = store.getInt(IPDebugConstants.PREF_PTP_DEBUG_COMM_TIMEOUT);
        IPJob job = this.getLaunchManager().run((ILaunch)pLaunch, jrunconfig, (IProgressMonitor)new SubProgressMonitor(monitor, 150));
        pLaunch.setAttribute("JOB_ID", job.getIDString());
        monitor.setTaskName("Starting the debugger . . .");
        String dbgExe = ParallelLaunchConfigurationDelegate.getDebuggerExePath(configuration);
        if (dbgExe != null) {
            Path dbgExePath = new Path(dbgExe);
            job.setAttribute("app_name", (Object)dbgExePath.lastSegment());
            job.setAttribute("app_path", (Object)dbgExePath.removeLastSegments(1).toOSString());
        } else {
            job.setAttribute("app_name", (Object)jrunconfig.getExecName());
            job.setAttribute("app_path", (Object)jrunconfig.getPathToExec());
        }
        String wd = ParallelLaunchConfigurationDelegate.getDebuggerWorkDirectory(configuration);
        if (wd != null) {
            job.setAttribute("work_dir", (Object)wd);
        } else {
            job.setAttribute("work_dir", (Object)jrunconfig.getWorkingDir());
        }
        job.setAttribute("args", (Object)jrunconfig.getArguments());
        job.setAttribute("debug_dir", (Object)jrunconfig.getPathToExec());
        pLaunch.setPJob(job);
        this.showPTPDebugView(IPTPDebugUIConstants.ID_VIEW_PARALLELDEBUG);
        try {
            try {
                PTPDebugCorePlugin.getDebugModel().createDebuggerSession(debugger, pLaunch, exeFile, timeout, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                monitor.worked(10);
                if (monitor.isCanceled()) {
                    PTPDebugCorePlugin.getDebugModel().shutdownSession(job);
                }
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.getDebugModel().shutdownSession(job);
                if (e.getStatus().getCode() != 8) {
                    throw e;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void switchPerspectiveTo(final String perspectiveID) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                    if (window != null && !(page = window.getActivePage()).getPerspective().getId().equals(perspectiveID)) {
                        try {
                            window.getWorkbench().showPerspective(perspectiveID, window);
                        }
                        catch (WorkbenchException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private void showPTPDebugView(final String viewID) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        try {
                            page.showView(viewID, null, 3);
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
        }
    }
}

