/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.core.CoreMessages;
import org.eclipse.ptp.launch.internal.ui.LaunchImages;
import org.eclipse.ptp.launch.ui.PLaunchConfigurationTab;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParallelTab
extends PLaunchConfigurationTab {
    protected Combo machineCombo;
    protected IntegerFieldEditor numberOfProcessField = null;
    protected WidgetListener listener = new WidgetListener();

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        Composite parallelComp = new Composite(comp, 0);
        parallelComp.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        parallelComp.setLayoutData((Object)this.spanGridData(768, 5));
        this.createVerticalSpacer(parallelComp, 2);
        PTPUIPlugin.getDefault().refreshRuntimeSystem(false, false);
        IPUniverse universe = PTPCorePlugin.getDefault().getModelManager().getUniverse();
        if (universe == null) {
            return;
        }
        IPMachine[] macs = universe.getSortedMachines();
        new Label(parallelComp, 0).setText("Select machine:");
        this.machineCombo = new Combo(parallelComp, 8);
        int i = 0;
        while (i < macs.length) {
            this.machineCombo.add(macs[i].getElementName());
            ++i;
        }
        this.machineCombo.select(0);
        this.machineCombo.addSelectionListener((SelectionListener)this.listener);
        this.numberOfProcessField = new IntegerFieldEditor("numberOfProcess", CoreMessages.getResourceString((String)"ParallelTab.Number_Of_Processes"), parallelComp);
        this.numberOfProcessField.setValidRange(1, 100000);
        this.numberOfProcessField.setPropertyChangeListener((IPropertyChangeListener)this.listener);
        this.createVerticalSpacer(parallelComp, 2);
    }

    public void updateComboFromSelection() {
        System.out.println("change startup");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES", "0");
        configuration.setAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES_START", "1");
        configuration.setAttribute("org.eclipse.ptp.launch.NODE_NUMBER", "0");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.numberOfProcessField.setStringValue(configuration.getAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES", ""));
            int idx = this.getMachineNameIndex(configuration.getAttribute("org.eclipse.ptp.launch.MACHINE_NAME", ""));
            this.machineCombo.select(idx);
        }
        catch (CoreException e) {
            this.setErrorMessage(CoreMessages.getFormattedResourceString((String)"CommonTab.common.Exception_occurred_reading_configuration_EXCEPTION", (String)e.getStatus().getMessage()));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.MACHINE_NAME", this.getMachineName());
        configuration.setAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES", this.getFieldContent(this.numberOfProcessField));
    }

    protected String getMachineName() {
        IPUniverse universe = PTPCorePlugin.getDefault().getModelManager().getUniverse();
        if (universe == null) {
            return "";
        }
        IPMachine[] macs = universe.getSortedMachines();
        int i = this.machineCombo.getSelectionIndex();
        return macs[i].getElementName();
    }

    protected int getMachineNameIndex(String machineName) {
        IPUniverse universe = PTPCorePlugin.getDefault().getModelManager().getUniverse();
        if (universe == null) {
            return -1;
        }
        IPMachine[] macs = universe.getSortedMachines();
        int found = -1;
        int i = 0;
        while (i < macs.length) {
            if (macs[i].getElementName().equals(machineName)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found == -1) {
            found = 0;
        }
        return found;
    }

    protected String getFieldContent(IntegerFieldEditor editorField) {
        return this.getFieldContent(editorField.getStringValue());
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.numberOfProcessField.isValid()) {
            this.setErrorMessage(this.numberOfProcessField.getErrorMessage());
            return false;
        }
        return true;
    }

    public String getName() {
        return CoreMessages.getResourceString((String)"ParallelTab.Parallel");
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    public Image getImage() {
        return LaunchImages.getImage("org.eclipse.ptp.launch.parallel_tab.gif");
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ParallelTab.this.updateLaunchConfigurationDialog();
        }

        public void propertyChange(PropertyChangeEvent event) {
            ParallelTab.this.updateLaunchConfigurationDialog();
        }
    }
}

