/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.actions;

import java.util.List;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.core.resources.IFile;
import org.eclipse.ptp.pldt.common.ArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseBase;
import org.eclipse.ptp.pldt.common.util.AnalysisUtil;
import org.eclipse.ptp.pldt.common.util.ViewActivater;
import org.eclipse.ptp.pldt.mpi.core.MPIArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.mpi.core.MpiPlugin;
import org.eclipse.ptp.pldt.mpi.core.analysis.MpiCASTVisitor;
import org.eclipse.ptp.pldt.mpi.core.analysis.MpiCPPASTVisitor;

public class RunAnalyseMPI
extends RunAnalyseBase {
    public RunAnalyseMPI() {
        super("MPI", (ArtifactMarkingVisitor)new MPIArtifactMarkingVisitor("org.eclipse.ptp.pldt.mpi.core.mpiMarker"), "org.eclipse.ptp.pldt.mpi.core.mpiMarker");
    }

    public ScanReturn doArtifactAnalysis(IFile file, List includes) {
        ScanReturn msr = new ScanReturn();
        String fileName = file.getName();
        ParserLanguage lang = AnalysisUtil.getLanguageFromFile((IFile)file);
        try {
            IASTTranslationUnit astTransUnit = CDOM.getInstance().getASTService().getTranslationUnit(file, CDOM.getInstance().getCodeReaderFactory(0));
            if (lang == ParserLanguage.C) {
                astTransUnit.accept((ASTVisitor)new MpiCASTVisitor(includes, fileName, msr));
            } else if (lang == ParserLanguage.CPP) {
                astTransUnit.accept((ASTVisitor)new MpiCPPASTVisitor(includes, fileName, msr));
            }
        }
        catch (IASTServiceProvider.UnsupportedDialectException e) {
            System.out.println("RunAnalyseMPI, UnsupportedDialectException " + e.getMessage());
        }
        return msr;
    }

    protected List getIncludePath() {
        return MpiPlugin.getDefault().getMpiIncludeDirs();
    }

    protected void activateArtifactView() {
        ViewActivater.activateView((String)"org.eclipse.ptp.pldt.mpi.core.views.MPITableView");
    }

    protected void activateProblemsView() {
    }
}

