/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.dictionary;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;

public class Symbol {
    protected IASTDeclarator declarator_ = null;
    protected IASTNode declaration_ = null;

    public Symbol(IASTDeclarator declarator, IASTDeclaration declaration) {
        this.declarator_ = declarator;
        this.declaration_ = declaration;
    }

    public Symbol(IASTDeclarator declarator, IASTParameterDeclaration declaration) {
        this.declarator_ = declarator;
        this.declaration_ = declaration;
    }

    public IASTName getName() {
        return this.declarator_.getName();
    }

    public IASTDeclarator getDeclarator() {
        return this.declarator_;
    }

    public IASTNode getDeclaration() {
        return this.declaration_;
    }

    public IScope getScope() {
        IASTName name = this.declarator_.getName();
        name.resolveBinding();
        IBinding binding = name.getBinding();
        if (binding == null) {
            return null;
        }
        IScope scope = null;
        try {
            scope = binding.getScope();
        }
        catch (DOMException e) {
            System.out.println("SymbolBucket.find: exception " + (Object)((Object)e));
            return null;
        }
        return scope;
    }

    public IASTNode getDefiningFunction() {
        IScope scope = this.getScope();
        if (scope == null) {
            return null;
        }
        IASTNode node = null;
        try {
            node = scope.getPhysicalNode();
        }
        catch (DOMException e) {
            System.out.println("Symbol.getFunction exception " + (Object)((Object)e));
            return null;
        }
        while (node != null) {
            if (node instanceof IASTTranslationUnit) {
                return node;
            }
            if (node instanceof IASTFunctionDefinition) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }
}

