/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.util.Hashtable;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.ptp.pldt.openmp.analysis.Utility;

public class StatementMap {
    protected Member root_ = null;
    protected Hashtable iastnodeToMember_ = new Hashtable();

    public boolean add(IASTNode node) {
        if (node == null) {
            return false;
        }
        Member m = new Member(node);
        this.RBInsert(m);
        this.iastnodeToMember_.put(node, m);
        return true;
    }

    public Location getLocation(IASTNode node) {
        Utility.Location l = Utility.getLocation(node);
        return new Location(l.low_, l.high_);
    }

    public void remove(IASTNode node) {
        Member m = (Member)this.iastnodeToMember_.get(node);
        if (m == null) {
            return;
        }
        this.RBDelete(m);
        this.iastnodeToMember_.remove(node);
    }

    public IASTNode find(int offset, int length) {
        return this.findInterval(offset, offset + length - 1);
    }

    public IASTNode findInterval(int offset, int endset) {
        Member x = this.findIntervalMember(offset, endset);
        if (x != null) {
            return x.node_;
        }
        return null;
    }

    protected Member findIntervalMember(int offset, int endset) {
        Member x = this.root_;
        while (x != null && !this.overlap(x.low_, x.high_, offset, endset)) {
            x = x.left_ != null && x.left_.max_ >= offset ? x.left_ : x.right_;
        }
        return x;
    }

    protected boolean overlap(int offset1, int endset1, int offset2, int endset2) {
        return endset1 >= offset2 && endset2 >= offset1;
    }

    protected void RBDelete(Member z) {
        Member y = null;
        Member x = null;
        y = z.left_ == null || z.right_ == null ? z : this.treeSuccessor(z);
        x = y.left_ != null ? y.left_ : y.right_;
        x.parent_ = y.parent_;
        if (y.parent_ == null) {
            this.root_ = x;
        } else if (y == y.parent_.left_) {
            y.parent_.left_ = x;
        } else {
            y.parent_.right_ = x;
        }
        if (y != z) {
            z.copyFrom(y);
        }
        if (y.color_ == 1) {
            this.RBDeleteFixup(x);
        }
    }

    protected void RBDeleteFixup(Member x) {
        Member w = null;
        while (x != this.root_ && x.color_ == 1) {
            if (x == x.parent_.left_) {
                w = x.parent_.right_;
                if (w.color_ == 0) {
                    w.color_ = 1;
                    x.parent_.color_ = 0;
                    x.parent_.leftRotate();
                    w = x.parent_.right_;
                }
                if (w.left_.color_ == 1 && w.right_.color_ == 1) {
                    w.color_ = 0;
                    x = x.parent_;
                    continue;
                }
                if (w.right_.color_ == 1) {
                    w.left_.color_ = 1;
                    w.color_ = 0;
                    w.rightRotate();
                    w = x.parent_.right_;
                }
                w.color_ = x.parent_.color_;
                x.parent_.color_ = 1;
                w.right_.color_ = 1;
                x.parent_.leftRotate();
                x = this.root_;
                continue;
            }
            w = x.parent_.left_;
            if (w.color_ == 0) {
                w.color_ = 1;
                x.parent_.color_ = 0;
                x.parent_.rightRotate();
                w = x.parent_.left_;
            }
            if (w.right_.color_ == 1 && w.left_.color_ == 1) {
                w.color_ = 0;
                x = x.parent_;
                continue;
            }
            if (w.left_.color_ == 1) {
                w.right_.color_ = 1;
                w.color_ = 0;
                w.leftRotate();
                w = x.parent_.left_;
            }
            w.color_ = x.parent_.color_;
            x.parent_.color_ = 1;
            w.left_.color_ = 1;
            x.parent_.rightRotate();
            x = this.root_;
        }
        x.color_ = 1;
    }

    protected void RBInsert(Member x) {
        Member y = null;
        this.treeInsert(x);
        x.updateMax();
        x.color_ = 0;
        while (x != this.root_ && x.parent_.color_ == 0) {
            if (x.parent_ == x.parent_.parent_.left_) {
                y = x.parent_.parent_.left_;
                if (y.color_ == 0) {
                    x.parent_.color_ = 1;
                    y.color_ = 1;
                    x.parent_.parent_.color_ = 0;
                    x = x.parent_.parent_;
                    continue;
                }
                if (x == x.parent_.right_) {
                    x = x.parent_;
                    x.leftRotate();
                }
                x.parent_.color_ = 1;
                x.parent_.parent_.color_ = 0;
                x.parent_.parent_.rightRotate();
                continue;
            }
            y = x.parent_.parent_.right_;
            if (y.color_ == 0) {
                x.parent_.color_ = 1;
                y.color_ = 1;
                x.parent_.parent_.color_ = 0;
                x = x.parent_.parent_;
                continue;
            }
            if (x == x.parent_.left_) {
                x = x.parent_;
                x.rightRotate();
            }
            x.parent_.color_ = 1;
            x.parent_.parent_.color_ = 0;
            x.parent_.parent_.leftRotate();
        }
        this.root_.color_ = 1;
    }

    protected void treeInsert(Member z) {
        Member y = null;
        Member x = this.root_;
        while (x != null) {
            y = x;
            Member member = x = z.low_ < x.low_ ? x.left_ : x.right_;
        }
        z.parent_ = y;
        if (y == null) {
            this.root_ = z;
        } else if (z.low_ < y.low_) {
            y.left_ = z;
        } else {
            y.right_ = z;
        }
    }

    protected Member treeSuccessor(Member x) {
        if (x.right_ != null) {
            return this.treeMinimum(x.right_);
        }
        Member y = x.parent_;
        while (y != null && x == y.right_) {
            x = y;
            y = y.parent_;
        }
        return y;
    }

    protected Member treeMaximum(Member x) {
        while (x.right_ != null) {
            x = x.right_;
        }
        return x;
    }

    protected Member treeMinimum(Member x) {
        while (x.left_ != null) {
            x = x.left_;
        }
        return x;
    }

    protected void add(int offset, int endset) {
        Member m = new Member(offset, endset);
        this.RBInsert(m);
    }

    public static void main(String[] args) {
        StatementMap sm = new StatementMap();
        sm.add(12, 15);
        sm.add(1, 6);
        sm.add(14, 24);
        Member m = sm.findIntervalMember(12, 12);
        if (m == null) {
            System.out.println("could not find 12");
        } else {
            System.out.println("found in " + m.low_ + ":" + m.high_);
        }
    }

    public class Member {
        protected int low_ = 0;
        protected int high_ = 0;
        protected int max_ = 0;
        protected int color_ = 0;
        protected IASTNode node_ = null;
        protected Member left_ = null;
        protected Member right_ = null;
        protected Member parent_ = null;
        public static final int RED = 0;
        public static final int BLACK = 1;

        public Member(int low, int high) {
            this.low_ = low;
            this.high_ = high;
        }

        public Member(Location l, IASTNode node) {
            this.low_ = l.low_;
            this.high_ = l.high_;
            this.node_ = node;
        }

        public Member(IASTNode node) {
            this(statementMap.getLocation(node), node);
        }

        public void copyFrom(Member y) {
            this.low_ = y.low_;
            this.high_ = y.high_;
            this.node_ = y.node_;
        }

        public void leftRotate() {
            Member y = this.right_;
            this.right_ = y.left_;
            if (y.left_ != null) {
                y.left_.parent_ = this;
            }
            y.parent_ = this.parent_;
            if (this.parent_ == null) {
                StatementMap.this.root_ = y;
            } else if (this == this.parent_.left_) {
                this.parent_.left_ = y;
            } else {
                this.parent_.right_ = y;
            }
            y.left_ = this;
            this.parent_ = y;
            this.updateMax();
            y.updateMax();
        }

        public void rightRotate() {
            Member x = this.left_;
            this.left_ = x.right_;
            if (x.right_ != null) {
                x.right_.parent_ = this;
            }
            x.parent_ = this.parent_;
            if (this.parent_ == null) {
                StatementMap.this.root_ = x;
            } else if (this == this.parent_.left_) {
                this.parent_.left_ = x;
            } else {
                this.parent_.right_ = x;
            }
            x.right_ = this;
            this.parent_ = x;
            this.updateMax();
            x.updateMax();
        }

        protected void updateMax() {
            int l = this.left_ != null ? this.left_.max_ : 0;
            int r = this.right_ != null ? this.right_.max_ : 0;
            this.max_ = Math.max(this.high_, Math.max(l, r));
        }
    }

    protected static class Location {
        public int low_ = 0;
        public int high_ = 0;

        public Location(int low, int high) {
            this.low_ = low;
            this.high_ = high;
        }
    }
}

