/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.core.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseBase;
import org.eclipse.ptp.pldt.common.util.AnalysisUtil;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.common.util.ViewActivater;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPAnalysisManager;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPError;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPErrorManager;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTNode;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.core.OpenMPArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.openmp.core.OpenMPPlugin;
import org.eclipse.ptp.pldt.openmp.core.OpenMPScanReturn;
import org.eclipse.ptp.pldt.openmp.core.analysis.OpenMPCASTVisitor;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class RunAnalyseOpenMP
extends RunAnalyseBase {
    private static final String OPENMP_DIRECTIVE = "OpenMP directive";

    public RunAnalyseOpenMP() {
        super("OpenMP", (ArtifactMarkingVisitor)new OpenMPArtifactMarkingVisitor("org.eclipse.ptp.pldt.openmp.core.openMPMarker"), "org.eclipse.ptp.pldt.openmp.core.openMPMarker");
    }

    public ScanReturn doArtifactAnalysis(IFile file, List includes) {
        OpenMPScanReturn msr = new OpenMPScanReturn();
        String fileName = file.getName();
        ParserLanguage lang = AnalysisUtil.getLanguageFromFile((IFile)file);
        IASTTranslationUnit astTransUnit = null;
        try {
            astTransUnit = CDOM.getInstance().getASTService().getTranslationUnit(file, CDOM.getInstance().getCodeReaderFactory(0));
            if (lang == ParserLanguage.C) {
                astTransUnit.accept((ASTVisitor)new OpenMPCASTVisitor(includes, fileName, msr));
            }
        }
        catch (IASTServiceProvider.UnsupportedDialectException unsupportedDialectException) {}
        this.processOpenMPPragmas(msr, astTransUnit, file);
        return msr;
    }

    protected void processOpenMPPragmas(OpenMPScanReturn msr, IASTTranslationUnit astTransUnit, IFile iFile) {
        OpenMPAnalysisManager omgr = new OpenMPAnalysisManager(astTransUnit, iFile);
        PASTNode[] pList = omgr.getPAST();
        int i = 0;
        while (i < pList.length) {
            if (pList[i] instanceof PASTOMPPragma) {
                PASTOMPPragma pop = (PASTOMPPragma)pList[i];
                SourceInfo si = this.getSourceInfo((PASTNode)pop, 0);
                Artifact a = new Artifact(pop.getFilename(), pop.getStartingLine(), pop.getStartLocation(), pop.getContent(), OPENMP_DIRECTIVE, si, (Object)pop);
                msr.addArtifact(a);
            }
            ++i;
        }
        msr.addProblems(OpenMPErrorManager.getCurrentErrorManager().getErrors());
    }

    private SourceInfo getSourceInfo(PASTNode pastNode, int constructType) {
        SourceInfo sourceInfo = null;
        IASTNodeLocation[] locations = pastNode.getNodeLocations();
        if (locations.length == 1) {
            IASTFileLocation astFileLocation = null;
            if (locations[0] instanceof IASTFileLocation) {
                astFileLocation = (IASTFileLocation)locations[0];
                sourceInfo = new SourceInfo();
                sourceInfo.setStartingLine(astFileLocation.getStartingLineNumber());
                sourceInfo.setStart(astFileLocation.getNodeOffset());
                sourceInfo.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                sourceInfo.setConstructType(constructType);
            }
        }
        return sourceInfo;
    }

    protected List getIncludePath() {
        return OpenMPPlugin.getDefault().getIncludeDirs();
    }

    protected void activateArtifactView() {
        ViewActivater.activateView((String)"org.eclipse.ptp.pldt.openmp.core.views.OpenMPArtifactView");
    }

    protected void activateProblemsView() {
        ViewActivater.activateView((String)"org.eclipse.ptp.pldt.openmp.ui.pv.views.OpenMPProblemsView");
    }

    protected void processResults(ScanReturn results, IResource resource) {
        assert (results instanceof OpenMPScanReturn);
        OpenMPScanReturn osr = (OpenMPScanReturn)results;
        List artifacts = osr.getOpenMPList();
        this.visitor.visitFile(resource, artifacts);
        this.removeProblemMarkers(resource);
        LinkedList problems = osr.getProblems();
        try {
            Iterator i = problems.iterator();
            while (i.hasNext()) {
                this.processProblem((OpenMPError)i.next(), resource);
            }
        }
        catch (CoreException e) {
            System.out.println("RunAnalysisOpenMP.processResults exception: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    private void processProblem(OpenMPError problem, IResource resource) throws CoreException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("description", problem.getDescription());
        attrs.put("resource", problem.getFilename());
        attrs.put("infoldername", problem.getPath());
        attrs.put("location", new Integer(problem.getLineno()));
        attrs.put("problem", problem);
        MarkerUtilities.createMarker((IResource)resource, attrs, (String)"org.eclipse.ptp.pldt.openmp.ui.pv.openMPProblemMarker");
    }

    private void removeProblemMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.ptp.pldt.openmp.ui.pv.openMPProblemMarker", false, 2);
        }
        catch (CoreException e) {
            System.out.println((Object)e);
            System.out.println(e.toString());
            System.out.println("Problem deleting markers on OMP Problems: " + resource.getProjectRelativePath());
        }
    }
}

