/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.wizards.wizardPages;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageData;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.Assert;
import org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage;

public class MPIProjectRunnable
implements Runnable {
    private static final boolean traceOn = false;

    public void run() {
        String pageID = "org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage";
        String propID = "doMPIincludes";
        Object obj = MBSCustomPageManager.getPageProperty((String)pageID, (String)propID);
        boolean doMpiIncludes = MPIProjectWizardPage.getDefaultUseMpiIncludes();
        if (obj != null) {
            doMpiIncludes = Boolean.valueOf((String)obj);
        }
        if (!doMpiIncludes) {
            return;
        }
        MBSCustomPageData pData = MBSCustomPageManager.getPageData((String)pageID);
        NewCProjectWizard wiz = (NewCProjectWizard)pData.getWizardPage().getWizard();
        IProject proj = wiz.getNewProject();
        propID = "includePath";
        String newIncludePath = this.getNewPropValue(pageID, propID, "c:/mpich2/include");
        propID = "lib";
        String newLib = this.getNewPropValue(pageID, propID, "lib");
        propID = "libPath";
        String newLibSearchPath = this.getNewPropValue(pageID, propID, "c:/mpich2/lib");
        propID = "mpiCompileCommand";
        String mpiCompileCommand = this.getNewPropValue(pageID, propID, "mpicc");
        propID = "mpiLinkCommand";
        String mpiLinkCommand = this.getNewPropValue(pageID, propID, "mpicc");
        IManagedBuildInfo info = null;
        try {
            info = ManagedBuildManager.getBuildInfo((IResource)proj);
        }
        catch (Exception e) {
            System.out.println("MPIProjectRunnable.run(), " + e.getMessage());
            e.printStackTrace();
            return;
        }
        Assert.isNotNull((Object)info);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration[] configs = mProj.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration cf = configs[i];
            this.addIncludePath(cf, newIncludePath);
            this.addLinkerOpt(cf, newLib, newLibSearchPath);
            this.setCompileCommand(cf, mpiCompileCommand);
            this.setLinkCommand(cf, mpiLinkCommand);
            ++i;
        }
        ManagedBuildManager.saveBuildInfo((IProject)proj, (boolean)true);
    }

    private String getNewPropValue(String pageID, String propID, String defaultVal) {
        Object obj = MBSCustomPageManager.getPageProperty((String)pageID, (String)propID);
        String newValue = defaultVal;
        if (obj != null) {
            newValue = obj.toString();
        }
        return newValue;
    }

    private void addIncludePath(IConfiguration cf, String newIncludePath) {
        String ext = "c";
        ITool cfTool = cf.getToolFromInputExtension(ext);
        String optID = "gnu.c.compiler.option.include.paths";
        IOption option = cfTool.getOptionById(optID);
        Assert.isNotNull((Object)option);
        String[] includePaths = null;
        try {
            includePaths = option.getIncludePaths();
        }
        catch (BuildException e) {
            System.out.println("MPIProjectRunnable, problem getting include paths: " + e.getMessage());
            e.printStackTrace();
        }
        String[] newIncludePaths = this.add(includePaths, newIncludePath);
        ManagedBuildManager.setOption((IConfiguration)cf, (IHoldsOptions)cfTool, (IOption)option, (String[])newIncludePaths);
    }

    private void addLinkerOpt(IConfiguration cf, String libName, String libPath) {
        String ext = "o";
        ITool cfTool = cf.getToolFromInputExtension(ext);
        String optLibsID = "gnu.c.link.option.libs";
        IOption option = cfTool.getOptionById(optLibsID);
        this.addOptionValue(cf, cfTool, option, libName);
        String optPathsID = "gnu.c.link.option.paths";
        option = cfTool.getOptionById(optPathsID);
        this.addOptionValue(cf, cfTool, option, libPath);
    }

    private void setCompileCommand(IConfiguration cf, String buildCmd) {
        ITool compiler = cf.getToolFromInputExtension("c");
        compiler.setToolCommand(buildCmd);
    }

    private void setLinkCommand(IConfiguration cf, String buildCmd) {
        ITool linker = cf.getToolFromInputExtension("o");
        linker.setToolCommand(buildCmd);
    }

    private void addOptionValue(IConfiguration cf, ITool tool, IOption option, String value) {
        try {
            int type = option.getValueType();
            String[] valueList = null;
            switch (type) {
                case 4: {
                    valueList = option.getIncludePaths();
                    valueList = this.add(valueList, value);
                    break;
                }
                case 6: {
                    valueList = option.getLibraries();
                    valueList = this.addNotPath(valueList, value);
                    break;
                }
                case 3: {
                    valueList = option.getStringListValue();
                    valueList = this.addNotPath(valueList, value);
                    break;
                }
                default: {
                    System.out.println("Wizard runnable postprocessing, can't get type of option for " + option.getName());
                    return;
                }
            }
            ManagedBuildManager.setOption((IConfiguration)cf, (IHoldsOptions)tool, (IOption)option, (String[])valueList);
        }
        catch (BuildException e) {
            System.out.println("MPIProjectRunnable.addOptionValue(), " + e.getMessage());
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void showOptions(IManagedProject proj) {
        IConfiguration[] configs = proj.getConfigurations();
        try {
            int i = 0;
            while (i < configs.length) {
                String foundOptionID;
                IOption opt;
                int j;
                IOption[] options;
                IConfiguration cf = configs[i];
                ITool[] allTools = cf.getTools();
                int numTools = allTools.length;
                System.out.println("Config " + i + ": " + cf.getName() + " has " + numTools + " tools.");
                int k = 0;
                while (k < allTools.length) {
                    ITool tool = allTools[k];
                    System.out.println("  Tool " + k + ": " + tool.getName());
                    String toolCmd = tool.getToolCommand();
                    String toolID = tool.getId();
                    System.out.println("  cmd=" + toolCmd + "  toolID=" + toolID);
                    options = tool.getOptions();
                    j = 0;
                    while (j < options.length) {
                        opt = options[j];
                        foundOptionID = opt.getId();
                        System.out.println("    option " + j + " " + opt.getName() + " id=" + foundOptionID);
                        if (opt.getValueType() == 4) {
                            this.showIncludePaths(opt);
                        }
                        ++j;
                    }
                    ++k;
                }
                System.out.println("Config " + i + ": " + cf.getName() + "======= End of ALL tools ");
                String ext = "c";
                ITool cfTool = cf.getToolFromInputExtension(ext);
                System.out.println("Tool by ext: " + ext + " is: " + cfTool.getName());
                String optID = "gnu.c.compiler.option.include.paths";
                IOption option = cfTool.getOptionById(optID);
                System.out.println("Option " + optID + " is " + option.getName());
                options = cfTool.getOptions();
                j = 0;
                while (j < options.length) {
                    opt = options[j];
                    foundOptionID = opt.getId();
                    System.out.println("  option " + j + " " + opt.getName() + " id=" + foundOptionID);
                    if (opt.getValueType() == 4) {
                        this.showIncludePaths(opt);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showIncludePaths(IOption opt) throws BuildException {
        Assert.isTrue((opt.getValueType() == 4 ? 1 : 0) != 0);
        String[] includePaths = opt.getIncludePaths();
        int index = 0;
        while (index < includePaths.length) {
            String path = includePaths[index];
            System.out.println("   include path " + index + ": " + path);
            ++index;
        }
    }

    private String[] add(String[] includePaths, String newPath) {
        String path;
        String pathSep = File.pathSeparator;
        ArrayList<String> newPathList = new ArrayList<String>();
        int i = 0;
        while (i < includePaths.length) {
            path = includePaths[i];
            newPathList.add(path);
            ++i;
        }
        String[] newPathArray = newPath.split(pathSep);
        int i2 = 0;
        while (i2 < newPathArray.length) {
            path = newPathArray[i2];
            newPathList.add(path);
            ++i2;
        }
        String[] newArray = newPathList.toArray(new String[0]);
        return newArray;
    }

    private String[] addNotPath(String[] strList, String newStr) {
        int len = strList.length;
        String[] newList = new String[len + 1];
        System.arraycopy(strList, 0, newList, 0, len);
        newList[len] = newStr;
        return newList;
    }
}

