/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.exception.UnableToForwardPortException;

public class LocalConnection
implements IRemoteConnection {
    private String name = "Local";
    private String address = "localhost";
    private String username = System.getProperty("user.name");
    private boolean connected = false;

    public void close(IProgressMonitor monitor) {
        this.connected = false;
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isOpen() {
        return this.connected;
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        this.connected = true;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean supportsTCPPortForwarding() {
        return false;
    }
}

