/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.AbstractEventResultRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIGetPartialAIFRequest;

public abstract class AbstractGetPartialAIFRequest
extends AbstractEventResultRequest
implements IPDIGetPartialAIFRequest {
    private String expr;
    private String varid;
    private boolean listChildren = false;
    private boolean express = false;

    public AbstractGetPartialAIFRequest(BitList tasks, String expr, String varid) {
        this(tasks, expr, varid, false, varid != null);
    }

    public AbstractGetPartialAIFRequest(BitList tasks, String expr, String varid, boolean listChildren) {
        this(tasks, expr, varid, listChildren, false);
    }

    public AbstractGetPartialAIFRequest(BitList tasks, String expr, String varid, boolean listChildren, boolean express) {
        super(tasks);
        this.expr = expr;
        this.varid = varid;
        this.listChildren = listChildren;
        this.express = express;
    }

    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.retrievePartialAIF(this.tasks, this.expr, this.varid, this.listChildren, this.express);
    }

    public String getName() {
        return "Get partial aif request";
    }

    public IAIF getPartialAIF(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            return (IAIF)returnValues[1];
        }
        throw new PDIException(qTasks, "Variable " + this.expr + ": No aif found");
    }

    public String getVarId(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            return (String)returnValues[0];
        }
        throw new PDIException(qTasks, "Variable ID " + this.varid + ": No variable ID found");
    }

    public String toString() {
        return String.valueOf(this.getName()) + " for tasks " + BitList.showBitList((BitList)this.getTasks()) + ", exp: " + this.expr + ", var id: " + this.varid + ", is list children: " + this.listChildren + ", is express: " + this.express;
    }
}

