/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.orte.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.IRemoteServices;
import org.eclipse.ptp.remote.PTPRemotePlugin;
import org.eclipse.ptp.remote.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.orte.core.rmsystem.ORTEResourceManagerConfiguration;
import org.eclipse.ptp.rm.orte.ui.internal.ui.Messages;
import org.eclipse.ptp.ui.utils.SWTUtil;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizard;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ORTEConfigurationWizardPage
extends RMConfigurationWizardPage {
    public static final String EMPTY_STRING = "";
    private ORTEResourceManagerConfiguration config;
    private String ortedPath = "";
    private String ortedArgs = "";
    private IRemoteServices remoteServices = null;
    private IRemoteConnection connection = null;
    private boolean loading = true;
    private boolean isValid;
    private boolean useDefaults;
    private Text pathText = null;
    private Text argsText = null;
    private Button browseButton = null;
    private Button defaultButton = null;
    private WidgetListener listener = new WidgetListener();

    public ORTEConfigurationWizardPage(RMConfigurationWizard wizard) {
        super(wizard, Messages.getString("ORTEConfigurationWizardPage.name"));
        this.setTitle(Messages.getString("ORTEConfigurationWizardPage.title"));
        this.setDescription(Messages.getString("ORTEConfigurationWizardPage.description"));
        this.setPageComplete(true);
        this.isValid = true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        composite.setLayout((Layout)topLayout);
        this.createContents(composite);
        this.setControl((Control)composite);
    }

    public boolean performOk() {
        this.store();
        this.config.setUseDefaults(this.useDefaults);
        if (!this.useDefaults) {
            this.config.setOrtedPath(this.ortedPath);
            this.config.setOrtedArgs(this.ortedArgs);
        }
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initContents();
        }
        super.setVisible(visible);
    }

    private void createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        contents.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        contents.setLayoutData((Object)gd);
        this.defaultButton = this.createCheckButton(contents, Messages.getString("ORTEConfigurationWizardPage.defaultButton"));
        this.defaultButton.addSelectionListener((SelectionListener)this.listener);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.defaultButton.setLayoutData((Object)gd);
        Label label = new Label(contents, 0);
        label.setText(Messages.getString("ORTEConfigurationWizardPage.path"));
        this.pathText = new Text(contents, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 60;
        this.pathText.setLayoutData((Object)gd);
        this.pathText.addModifyListener((ModifyListener)this.listener);
        this.browseButton = SWTUtil.createPushButton((Composite)contents, (String)Messages.getString("ORTEConfigurationWizardPage.browseButton"), null);
        this.browseButton.addSelectionListener((SelectionListener)this.listener);
        label = new Label(contents, 0);
        label.setText(Messages.getString("ORTEConfigurationWizardPage.arguments"));
        this.argsText = new Text(contents, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.argsText.setLayoutData((Object)gd);
        this.argsText.addModifyListener((ModifyListener)this.listener);
    }

    private void initContents() {
        this.loading = true;
        this.config = (ORTEResourceManagerConfiguration)this.getConfigurationWizard().getConfiguration();
        this.loadSaved();
        this.updateSettings();
        this.defaultSetting();
        this.loading = false;
        this.updatePage();
    }

    private void loadSaved() {
        this.useDefaults = this.config.useDefaults();
        this.ortedPath = this.config.getOrtedPath();
        this.ortedArgs = this.config.getOrtedArgs();
    }

    private void setValid(boolean b) {
        this.isValid = b;
        this.setPageComplete(this.isValid);
    }

    private void store() {
        if (!this.loading) {
            if (this.defaultButton != null) {
                this.useDefaults = this.defaultButton.getSelection();
            }
            if (this.pathText != null) {
                this.ortedPath = this.pathText.getText();
            }
            if (this.argsText != null) {
                this.ortedArgs = this.argsText.getText();
            }
        }
    }

    private void updateSettings() {
        this.store();
        this.pathText.setEnabled(!this.useDefaults);
        this.argsText.setEnabled(!this.useDefaults);
        this.browseButton.setEnabled(!this.useDefaults);
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected void defaultSetting() {
        this.defaultButton.setSelection(this.useDefaults);
        this.pathText.setText(this.ortedPath);
        this.argsText.setText(this.ortedArgs);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected void handlePathBrowseButtonSelected() {
        String rmID = this.config.getRemoteServicesId();
        if (rmID != null) {
            this.remoteServices = PTPRemotePlugin.getDefault().getRemoteServices(rmID);
            String conn = this.config.getConnectionName();
            if (this.remoteServices != null && conn != null) {
                this.connection = this.remoteServices.getConnectionManager().getConnection(conn);
            }
        }
        if (this.connection != null) {
            if (!this.connection.isOpen()) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ORTEConfigurationWizardPage.this.connection.open(monitor);
                        }
                        catch (RemoteConnectionException e) {
                            ErrorDialog.openError((Shell)ORTEConfigurationWizardPage.this.getShell(), (String)Messages.getString("ORTEConfigurationWizardPage.connection_error"), (String)Messages.getString("ORTEConfigurationWizardPage.connection_error_msg"), (IStatus)new Status(4, "org.eclipse.ptp.rm.orte.ui", e.getMessage()));
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, op);
                }
                catch (InvocationTargetException e) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("ORTEConfigurationWizardPage.connection_error"), (String)Messages.getString("ORTEConfigurationWizardPage.connection_error_msg"), (IStatus)new Status(4, "org.eclipse.ptp.rm.orte.ui", e.getMessage()));
                }
                catch (InterruptedException e) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("ORTEConfigurationWizardPage.connection_error"), (String)Messages.getString("ORTEConfigurationWizardPage.connection_error_msg"), (IStatus)new Status(4, "org.eclipse.ptp.rm.orte.ui", e.getMessage()));
                }
            }
            IRemoteFileManager fileMgr = this.remoteServices.getFileManager(this.connection);
            String initialPath = "//";
            IPath selectedPath = fileMgr.browseFile(this.getControl().getShell(), Messages.getString("ORTEConfigurationWizardPage.select"), initialPath);
            if (selectedPath != null) {
                this.pathText.setText(selectedPath.toString());
            }
        }
    }

    protected boolean isValidSetting() {
        String name;
        if (this.defaultButton != null && this.defaultButton.getSelection()) {
            return true;
        }
        if (this.pathText != null && (name = this.getFieldContent(this.pathText.getText())) == null) {
            this.setErrorMessage(Messages.getString("ORTEConfigurationWizardPage.invalid"));
            return false;
        }
        return true;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidSetting()) {
            this.setValid(false);
        } else {
            this.performOk();
            this.setValid(true);
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (!(ORTEConfigurationWizardPage.this.loading || source != ORTEConfigurationWizardPage.this.pathText && source != ORTEConfigurationWizardPage.this.argsText)) {
                ORTEConfigurationWizardPage.this.updatePage();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                ORTEConfigurationWizardPage.this.updatePage();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ORTEConfigurationWizardPage.this.browseButton) {
                ORTEConfigurationWizardPage.this.handlePathBrowseButtonSelected();
            } else {
                ORTEConfigurationWizardPage.this.updateSettings();
                ORTEConfigurationWizardPage.this.updatePage();
            }
        }
    }
}

