/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.exception.AddressInUseException;
import org.eclipse.ptp.remote.exception.UnableToForwardPortException;
import org.eclipse.ptp.remote.remotetools.environment.core.PTPTargetControl;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.PortForwardingException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;

public class RemoteToolsConnection
implements IRemoteConnection {
    private String connName;
    private String address;
    private String userName;
    private PTPTargetControl control;

    public RemoteToolsConnection(String name, String address, String userName, PTPTargetControl control) {
        this.control = control;
        this.connName = name;
        this.address = address;
        this.userName = userName;
    }

    public synchronized void close(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Closing connection...", 1);
        try {
            this.control.kill(monitor);
        }
        catch (CoreException coreException) {}
        monitor.done();
    }

    public IRemoteExecutionManager createExecutionManager() throws RemoteConnectionException {
        return this.control.createExecutionManager();
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws org.eclipse.ptp.remote.exception.RemoteConnectionException {
        if (!this.isOpen()) {
            throw new org.eclipse.ptp.remote.exception.RemoteConnectionException("Connection is not open");
        }
        try {
            this.control.getExecutionManager().createTunnel(localPort, fwdAddress, fwdPort);
        }
        catch (LocalPortBoundException e) {
            throw new AddressInUseException(e.getMessage());
        }
        catch (RemoteConnectionException e) {
            throw new org.eclipse.ptp.remote.exception.RemoteConnectionException(e.getMessage());
        }
        catch (CancelException e) {
            throw new org.eclipse.ptp.remote.exception.RemoteConnectionException(e.getMessage());
        }
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws org.eclipse.ptp.remote.exception.RemoteConnectionException {
        if (!this.isOpen()) {
            throw new org.eclipse.ptp.remote.exception.RemoteConnectionException("Connection is not open");
        }
        return 0;
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws org.eclipse.ptp.remote.exception.RemoteConnectionException {
        if (!this.isOpen()) {
            throw new org.eclipse.ptp.remote.exception.RemoteConnectionException("Connection is not open");
        }
        try {
            this.control.getExecutionManager().getPortForwardingTools().forwardRemotePort(remotePort, fwdAddress, fwdPort);
        }
        catch (RemoteConnectionException e) {
            throw new org.eclipse.ptp.remote.exception.RemoteConnectionException(e.getMessage());
        }
        catch (CancelException e) {
            throw new org.eclipse.ptp.remote.exception.RemoteConnectionException(e.getMessage());
        }
        catch (PortForwardingException e) {
            throw new AddressInUseException(e.getMessage());
        }
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws org.eclipse.ptp.remote.exception.RemoteConnectionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Setting up remote forwarding", 10);
        int remotePort = fwdPort + 1;
        if (!monitor.isCanceled()) {
            try {
                this.forwardRemotePort(remotePort, fwdAddress, fwdPort);
            }
            catch (AddressInUseException addressInUseException) {
                if (++remotePort == fwdPort) {
                    throw new UnableToForwardPortException("Could not allocate remote port");
                }
                monitor.worked(1);
            }
            monitor.done();
            return remotePort;
        }
        monitor.done();
        return -1;
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.connName;
    }

    public String getUsername() {
        return this.userName;
    }

    public synchronized boolean isOpen() {
        return this.control.query() == 2;
    }

    public void open(IProgressMonitor monitor) throws org.eclipse.ptp.remote.exception.RemoteConnectionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Opening connection...", 2);
        if (this.control.query() == 1) {
            Job job = new Job("Start the  Environment"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = null;
                    try {
                        if (RemoteToolsConnection.this.control.create(monitor)) {
                            status = Status.OK_STATUS;
                        }
                    }
                    catch (CoreException e) {
                        status = e.getStatus();
                    }
                    return status;
                }
            };
            job.setUser(true);
            job.schedule();
            monitor.worked(1);
            while (!monitor.isCanceled() && this.control.query() != 2) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (monitor.isCanceled()) {
                job.cancel();
            }
        }
        monitor.done();
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setUsername(String userName) {
        this.userName = userName;
    }

    public boolean supportsTCPPortForwarding() {
        return true;
    }
}

