/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools;

import java.io.IOException;
import java.util.List;
import org.eclipse.ptp.remote.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteProcess;
import org.eclipse.ptp.remote.remotetools.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.RemoteToolsProcess;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.RemoteProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsProcessBuilder
extends AbstractRemoteProcessBuilder {
    private RemoteToolsConnection connection;

    public RemoteToolsProcessBuilder(RemoteToolsConnection conn, List<String> command) {
        super((IRemoteConnection)conn, command);
        this.connection = conn;
    }

    public RemoteToolsProcessBuilder(RemoteToolsConnection conn, String ... command) {
        super((IRemoteConnection)conn, command);
        this.connection = conn;
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    public IRemoteProcess start() throws IOException {
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.spaceEscapify((String)cmdArgs.get(i));
            ++i;
        }
        try {
            IRemoteExecutionManager exeMgr = this.connection.createExecutionManager();
            IRemoteExecutionTools exeTools = exeMgr.getExecutionTools();
            IRemoteScript script = exeTools.createScript();
            script.setScript(remoteCmd);
            RemoteProcess process = exeTools.executeProcess(script);
            return new RemoteToolsProcess((Process)process);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

