/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;

public class RemoveElementAction
extends ParallelAction {
    public static final String name = "Remove Elements";

    public RemoveElementAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_DELETEELEMENT_NORMAL);
    }

    public void run(IElement[] elements) {
        if (this.validation(elements)) {
            IElementSet set = this.view.getCurrentSet();
            if (set.size() == elements.length) {
                this.callDeleteGroupAction();
            } else {
                IElementHandler setManager = this.view.getCurrentElementHandler();
                if (setManager == null) {
                    return;
                }
                if (UIUtils.showQuestionDialog("Remove Confirmation", "Are you sure you want to remove (" + elements.length + ") elements from this set?")) {
                    this.view.getUIManager().removeFromSet(elements, set.getID(), setManager);
                    this.view.selectSet((IElementSet)setManager.getElementByID(set.getID()));
                    this.view.updateTitle();
                    this.view.refresh(false);
                }
            }
        }
    }

    private void callDeleteGroupAction() {
        IToolBarManager manager = this.view.getViewSite().getActionBars().getToolBarManager();
        IContributionItem item = manager.find("Delete Set");
        if (item != null && item instanceof ActionContributionItem) {
            ((ActionContributionItem)item).getAction().run();
        }
    }
}

