/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.adapters;

import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.internal.ui.adapters.PElementPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ResourceManagerPropertySource
extends PElementPropertySource {
    private final IResourceManager resourceManager;

    public ResourceManagerPropertySource(IResourceManager resourceManager) {
        super((IPElement)resourceManager);
        this.resourceManager = resourceManager;
        this.addDescriptor(new PropertyDescriptor((Object)"rm.machines", "num machines"));
        this.addDescriptor(new PropertyDescriptor((Object)"rm.queues", "num queues"));
    }

    public Object getPropertyValue(Object id) {
        Object value = super.getPropertyValue(id);
        if (value != null) {
            return value;
        }
        if ("rm.machines".equals(id)) {
            IPMachine[] machines = this.resourceManager.getMachines();
            return Integer.toString(machines.length);
        }
        if ("rm.queues".equals(id)) {
            IPQueue[] queues = this.resourceManager.getQueues();
            return Integer.toString(queues.length);
        }
        return null;
    }
}

