/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.adapters;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ptp.ui.UIMessage;
import org.eclipse.ptp.ui.utils.ImageImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;
import org.eclipse.ui.model.WorkbenchAdapter;

public class ResourceManagerWorkbenchAdapter
extends WorkbenchAdapter {
    public Object[] getChildren(Object parentElement) {
        IResourceManager rm = this.getResourceManager(parentElement);
        if (rm != null) {
            if (rm.getState() != ResourceManagerAttributes.State.STARTED) {
                return new Object[0];
            }
            Object[] machines = rm.getMachines();
            Object[] queues = rm.getQueues();
            return new Object[]{this.makeChildContainer(parentElement, UIMessage.getResourceString("ResourceManagerView.Machines"), machines), this.makeChildContainer(parentElement, UIMessage.getResourceString("ResourceManagerView.Queues"), queues)};
        }
        return null;
    }

    private IResourceManager getResourceManager(Object parentElement) {
        IResourceManager rm = null;
        if (parentElement instanceof IAdaptable) {
            rm = (IResourceManager)((IAdaptable)parentElement).getAdapter(IResourceManager.class);
        }
        return rm;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        ResourceManagerAttributes.State status = ((IResourceManager)object).getState();
        return new ImageImageDescriptor(ParallelImages.rmImages[status.ordinal()]);
    }

    public String getLabel(Object object) {
        IResourceManagerControl resourceManager = (IResourceManagerControl)object;
        IModelManager modelManager = PTPCorePlugin.getDefault().getModelManager();
        String resourceManagerId = resourceManager.getConfiguration().getResourceManagerId();
        if (resourceManagerId == null) {
            return resourceManager.getName();
        }
        IResourceManagerFactory factory = modelManager.getResourceManagerFactory(resourceManagerId);
        return String.valueOf(resourceManager.getName()) + " (" + factory.getName() + ")";
    }

    public Object getParent(Object object) {
        IResourceManagerControl rm = (IResourceManagerControl)this.getResourceManager(object);
        if (rm != null) {
            return rm.getParent();
        }
        return null;
    }

    private ChildContainer makeChildContainer(Object parent, String name, Object[] children) {
        ChildContainer container = new ChildContainer(parent, name, children);
        return container;
    }

    private class ChildContainer
    extends WorkbenchAdapter
    implements IAdaptable {
        private final Object parent;
        private final String name;
        private final Object[] children;

        public ChildContainer(Object parent, String name, Object[] children) {
            this.parent = parent;
            this.name = name;
            this.children = children;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IWorkbenchAdapter.class || adapter == IWorkbenchAdapter2.class) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            return (Object[])this.children.clone();
        }

        public String getLabel(Object object) {
            return this.name;
        }

        public Object getParent(Object object) {
            return this.parent;
        }
    }
}

