/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.ui.UIMessage;
import org.eclipse.swt.widgets.Shell;

public class RemoveResourceManagersAction
extends Action {
    private IResourceManagerControl[] selectedRMManagers;
    private final Shell shell;

    public RemoveResourceManagersAction(Shell shell) {
        super("Remove Resource Manager");
        this.shell = shell;
    }

    public void run() {
        String rmNames = "";
        int i = 0;
        while (i < this.selectedRMManagers.length) {
            if (i > 0) {
                rmNames = String.valueOf(rmNames) + ",";
            }
            rmNames = String.valueOf(rmNames) + "\n\t" + this.selectedRMManagers[i].getName();
            ++i;
        }
        boolean remove = MessageDialog.openConfirm((Shell)this.shell, (String)UIMessage.getResourceString("RemoveResourceManagersAction.Title"), (String)(String.valueOf(UIMessage.getResourceString("RemoveResourceManagersAction.Question")) + rmNames));
        if (remove) {
            PTPCorePlugin.getDefault().getModelManager().removeResourceManagers(this.selectedRMManagers);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setResourceManager(IResourceManagerControl[] rmManagers) {
        this.selectedRMManagers = (IResourceManagerControl[])rmManagers.clone();
    }
}

