/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.rmsystem.IResourceManagerMenuContribution;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.ptp.ui.actions.AbstractResourceManagerSelectionActionDelegate;
import org.eclipse.ui.PlatformUI;

public class StartResourceManagersObjectActionDelegate
extends AbstractResourceManagerSelectionActionDelegate {
    public void run(IAction action) {
        for (IResourceManagerMenuContribution menuContrib : this.getMenuContribs()) {
            final IResourceManager rmManager = (IResourceManager)menuContrib.getAdapter(IResourceManager.class);
            if (!this.isEnabledFor(rmManager)) continue;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        rmManager.startUp(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                IStatus status = null;
                if (t != null && t instanceof CoreException) {
                    status = ((CoreException)t).getStatus();
                }
                UIUtils.showErrorDialog("Start Resource Manager", "Failed to start resource manager", status);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected boolean isEnabledFor(IResourceManager rmManager) {
        return rmManager.getState() == ResourceManagerAttributes.State.STOPPED;
    }
}

