/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.consoles;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.events.IChangedJobEvent;
import org.eclipse.ptp.core.elements.events.IChangedMachineEvent;
import org.eclipse.ptp.core.elements.events.IChangedQueueEvent;
import org.eclipse.ptp.core.elements.events.INewJobEvent;
import org.eclipse.ptp.core.elements.events.INewMachineEvent;
import org.eclipse.ptp.core.elements.events.INewQueueEvent;
import org.eclipse.ptp.core.elements.events.IRemoveJobEvent;
import org.eclipse.ptp.core.elements.events.IRemoveMachineEvent;
import org.eclipse.ptp.core.elements.events.IRemoveQueueEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.elements.listeners.IQueueChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.events.IChangedResourceManagerEvent;
import org.eclipse.ptp.core.events.INewResourceManagerEvent;
import org.eclipse.ptp.core.events.IRemoveResourceManagerEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.ui.consoles.JobConsole;

public class ConsoleManager
implements IModelManagerChildListener,
IResourceManagerChildListener,
IQueueChildListener {
    private IModelManager imm = null;
    private Map<IPJob, JobConsole> consoles = new HashMap<IPJob, JobConsole>();

    public ConsoleManager() {
        this.imm = PTPCorePlugin.getDefault().getModelManager();
        this.imm.addListener((IModelManagerChildListener)this);
        IResourceManager[] iResourceManagerArray = this.imm.getUniverse().getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            rm.addChildListener((IResourceManagerChildListener)this);
            IPQueue[] iPQueueArray = rm.getQueues();
            int n3 = iPQueueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPQueue queue = iPQueueArray[n4];
                queue.addChildListener((IQueueChildListener)this);
                ++n4;
            }
            ++n2;
        }
    }

    public void handleEvent(IChangedJobEvent e) {
    }

    public void handleEvent(IChangedMachineEvent e) {
    }

    public void handleEvent(IChangedQueueEvent e) {
    }

    public void handleEvent(IChangedResourceManagerEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(INewJobEvent e) {
        for (IPJob job : e.getJobs()) {
            ILaunchConfiguration configuration = job.getLaunchConfiguration();
            try {
                if (configuration == null || !configuration.getAttribute("org.eclipse.ptp.launch.ATTR_CONSOLE", false)) continue;
                JobConsole jc = new JobConsole(job);
                job.addChildListener((IJobChildListener)jc);
                Map<IPJob, JobConsole> map = this.consoles;
                synchronized (map) {
                    this.consoles.put(job, jc);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void handleEvent(INewMachineEvent e) {
    }

    public void handleEvent(INewQueueEvent e) {
        for (IPQueue queue : e.getQueues()) {
            queue.addChildListener((IQueueChildListener)this);
        }
    }

    public void handleEvent(INewResourceManagerEvent e) {
        e.getResourceManager().addChildListener((IResourceManagerChildListener)this);
    }

    public void handleEvent(IRemoveJobEvent e) {
        for (IPJob job : e.getJobs()) {
            this.removeConsole(job);
        }
    }

    public void handleEvent(IRemoveMachineEvent e) {
    }

    public void handleEvent(IRemoveQueueEvent e) {
        for (IPQueue queue : e.getQueues()) {
            queue.removeChildListener((IQueueChildListener)this);
        }
    }

    public void handleEvent(IRemoveResourceManagerEvent e) {
        e.getResourceManager().removeChildListener((IResourceManagerChildListener)this);
    }

    public void shutdown() {
        this.imm.removeListener((IModelManagerChildListener)this);
        IResourceManager[] iResourceManagerArray = this.imm.getUniverse().getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            rm.removeChildListener((IResourceManagerChildListener)this);
            IPQueue[] iPQueueArray = rm.getQueues();
            int n3 = iPQueueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPQueue queue = iPQueueArray[n4];
                queue.removeChildListener((IQueueChildListener)this);
                IPJob[] iPJobArray = queue.getJobs();
                int n5 = iPJobArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IPJob job = iPJobArray[n6];
                    this.removeConsole(job);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsole(IPJob job) {
        Map<IPJob, JobConsole> map = this.consoles;
        synchronized (map) {
            JobConsole jc = this.consoles.get(job);
            if (jc != null) {
                jc.removeConsole();
                job.removeChildListener((IJobChildListener)jc);
                this.consoles.remove(jc);
            }
        }
    }
}

