/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.events.IChangedJobEvent;
import org.eclipse.ptp.core.elements.events.IChangedMachineEvent;
import org.eclipse.ptp.core.elements.events.IChangedQueueEvent;
import org.eclipse.ptp.core.elements.events.INewJobEvent;
import org.eclipse.ptp.core.elements.events.INewMachineEvent;
import org.eclipse.ptp.core.elements.events.INewQueueEvent;
import org.eclipse.ptp.core.elements.events.IRemoveJobEvent;
import org.eclipse.ptp.core.elements.events.IRemoveMachineEvent;
import org.eclipse.ptp.core.elements.events.IRemoveQueueEvent;
import org.eclipse.ptp.core.elements.listeners.IQueueChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.events.IChangedResourceManagerEvent;
import org.eclipse.ptp.core.events.INewResourceManagerEvent;
import org.eclipse.ptp.core.events.IRemoveResourceManagerEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.utils.PixelConverter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobsListView
extends ViewPart {
    private static final String TAG_COLUMN_WIDTHS = "columnWidths";
    private TableViewer viewer;
    private IMemento memento;
    private final IModelManagerChildListener modelManagerListener = new MMChildListener();
    private final IResourceManagerChildListener resourceManagerListener = new RMChildListener();
    private final IQueueChildListener queueChildListener = new QueueChildListener();
    private final Set<IAttributeDefinition<?, ?, ?>> colDefs = Collections.synchronizedSet(new HashSet());

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setUseHashlookup(true);
        this.createColumns(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IPUniverse) {
                    IPUniverse universe = (IPUniverse)inputElement;
                    ArrayList<IPJob> jobList = new ArrayList<IPJob>();
                    IResourceManager[] iResourceManagerArray = universe.getResourceManagers();
                    int n = iResourceManagerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceManager rm = iResourceManagerArray[n2];
                        IPQueue[] iPQueueArray = rm.getQueues();
                        int n3 = iPQueueArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPQueue queue = iPQueueArray[n4];
                            IPJob[] iPJobArray = queue.getJobs();
                            int n5 = iPJobArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IPJob job = iPJobArray[n6];
                                jobList.add(job);
                                ++n6;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    return jobList.toArray(new IPJob[jobList.size()]);
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object j1, Object j2) {
                return ((IPJob)j1).getName().compareTo(((IPJob)j2).getName());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IModelManager mm = PTPCorePlugin.getDefault().getModelManager();
        this.viewer.setInput((Object)mm.getUniverse());
        IResourceManager[] iResourceManagerArray = mm.getUniverse().getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            rm.addChildListener(this.resourceManagerListener);
            IPQueue[] iPQueueArray = rm.getQueues();
            int n3 = iPQueueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPQueue queue = iPQueueArray[n4];
                queue.addChildListener(this.queueChildListener);
                ++n4;
            }
            ++n2;
        }
        mm.addListener(this.modelManagerListener);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    private void refresh(final IPJob job) {
        PTPUIPlugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!JobsListView.this.viewer.getTable().isDisposed()) {
                    if (job != null) {
                        JobsListView.this.updateColumns(job);
                        JobsListView.this.viewer.refresh((Object)job);
                    } else {
                        JobsListView.this.viewer.refresh();
                    }
                }
            }
        });
    }

    public void setFocus() {
    }

    private void addColumn(final IAttributeDefinition<?, ?, ?> attrDef) {
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IPJob && attrDef.equals(JobAttributes.getStateAttributeDefinition())) {
                    IPJob job = (IPJob)element;
                    return ParallelImages.jobImages[job.getState().ordinal()][job.isDebug() ? 1 : 0];
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IPJob) {
                    IAttribute attr;
                    IPJob job = (IPJob)element;
                    if (!attrDef.equals(JobAttributes.getStateAttributeDefinition()) && (attr = job.getAttribute(attrDef.getId())) != null) {
                        return attr.getValueAsString();
                    }
                }
                return null;
            }
        });
        column.getColumn().setData(attrDef);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
        String name = attrDef.getName();
        column.getColumn().setText(name);
        PixelConverter converter = new PixelConverter(this.viewer.getControl());
        int width = Math.max(converter.convertWidthInCharsToPixels(name.length() + 2), converter.convertWidthInCharsToPixels(5));
        column.getColumn().setWidth(width);
        this.colDefs.add(attrDef);
    }

    private void addColumns(TableViewer tableViewer, IPJob job) {
        this.addColumn((IAttributeDefinition<?, ?, ?>)JobAttributes.getStateAttributeDefinition());
        this.addColumn((IAttributeDefinition<?, ?, ?>)ElementAttributes.getNameAttributeDefinition());
        if (job != null) {
            IAttribute[] iAttributeArray = job.getAttributes();
            int n = iAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAttribute attr = iAttributeArray[n2];
                IAttributeDefinition attrDef = attr.getDefinition();
                if (!this.colDefs.contains(attrDef) && attrDef.getDisplay()) {
                    this.addColumn(attrDef);
                }
                ++n2;
            }
        }
    }

    private void createColumns(TableViewer tableViewer) {
        this.addColumns(tableViewer, null);
    }

    private void updateColumns(IPJob job) {
        IAttribute[] iAttributeArray = job.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            IAttributeDefinition attrDef = attr.getDefinition();
            if (!this.colDefs.contains(attrDef) && attrDef.getDisplay()) {
                this.addColumn(attrDef);
            }
            ++n2;
        }
        this.viewer.getTable().layout(true);
    }

    private final class MMChildListener
    implements IModelManagerChildListener {
        private MMChildListener() {
        }

        public void handleEvent(IChangedResourceManagerEvent e) {
        }

        public void handleEvent(INewResourceManagerEvent e) {
            IResourceManager rm = e.getResourceManager();
            rm.addChildListener(JobsListView.this.resourceManagerListener);
        }

        public void handleEvent(IRemoveResourceManagerEvent e) {
            e.getResourceManager().removeChildListener(JobsListView.this.resourceManagerListener);
        }
    }

    private final class QueueChildListener
    implements IQueueChildListener {
        private QueueChildListener() {
        }

        public void handleEvent(IChangedJobEvent e) {
            for (IPJob job : e.getJobs()) {
                JobsListView.this.refresh(job);
            }
        }

        public void handleEvent(final INewJobEvent e) {
            PTPUIPlugin.getDisplay().syncExec(new Runnable(){

                public void run() {
                    JobsListView.this.updateColumns((IPJob)e.getJobs().iterator().next());
                }
            });
            JobsListView.this.refresh(null);
        }

        public void handleEvent(IRemoveJobEvent e) {
            JobsListView.this.refresh(null);
        }
    }

    private final class RMChildListener
    implements IResourceManagerChildListener {
        private RMChildListener() {
        }

        public void handleEvent(IChangedMachineEvent e) {
        }

        public void handleEvent(IChangedQueueEvent e) {
        }

        public void handleEvent(INewMachineEvent e) {
        }

        public void handleEvent(INewQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                queue.addChildListener(JobsListView.this.queueChildListener);
            }
        }

        public void handleEvent(IRemoveMachineEvent e) {
        }

        public void handleEvent(IRemoveQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                queue.removeChildListener(JobsListView.this.queueChildListener);
            }
        }
    }
}

