/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.internal.ui.Messages;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.IRemoteServices;
import org.eclipse.ptp.remote.PTPRemotePlugin;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SDMPage
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY_STRING = "";
    private IResourceManagerControl resourceManager = null;
    private IRemoteServices remoteServices = null;
    private IRemoteConnection connection = null;
    private String errMsg = null;
    protected Text fRMDebuggerPathText = null;
    protected Text fRMDebuggerAddressText = null;
    protected Button fRMDebuggerBrowseButton = null;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            this.fRMDebuggerAddressText.setText(this.getAddress(workingCopy));
            this.fRMDebuggerPathText.setText(workingCopy.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", EMPTY_STRING));
        }
        catch (CoreException coreException) {}
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("SDMDebuggerPage.path"));
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fRMDebuggerPathText = new Text(comp, 2052);
        this.fRMDebuggerPathText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fRMDebuggerPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRMDebuggerBrowseButton = this.createPushButton(comp, Messages.getString("SDMDebuggerPage.browse"), null);
        this.fRMDebuggerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file = SDMPage.this.browseFile();
                if (file != null) {
                    SDMPage.this.fRMDebuggerPathText.setText(file);
                }
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.getString("SDMDebuggerPage.host"));
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fRMDebuggerAddressText = new Text(comp, 2052);
        this.fRMDebuggerAddressText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fRMDebuggerAddressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)parent);
    }

    public String getName() {
        return Messages.getString("SDMDebuggerPage.debuggname");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String rmId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", EMPTY_STRING);
            this.resourceManager = (IResourceManagerControl)PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
            this.fRMDebuggerAddressText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", EMPTY_STRING));
            this.fRMDebuggerPathText.setText(configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", EMPTY_STRING));
        }
        catch (CoreException coreException) {}
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.errMsg = this.getFieldContent(this.fRMDebuggerPathText.getText()) == null ? Messages.getString("SDMDebuggerPage.err1") : (this.getFieldContent(this.fRMDebuggerAddressText.getText()) == null ? Messages.getString("SDMDebuggerPage.err3") : null);
        this.setErrorMessage(this.errMsg);
        return this.errMsg == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid((ILaunchConfiguration)configuration)) {
            configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", this.getFieldContent(this.fRMDebuggerPathText.getText()));
            configuration.setAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", this.getFieldContent(this.fRMDebuggerAddressText.getText()));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Preferences store = SDMDebugCorePlugin.getDefault().getPluginPreferences();
        String path = store.getString(SDMPreferenceConstants.SDM_DEBUGGER_FILE);
        try {
            IResourceManagerConfiguration rmConfig;
            String rmId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", EMPTY_STRING);
            IResourceManagerControl rm = (IResourceManagerControl)PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
            if (rm != null && (rmConfig = rm.getConfiguration()) instanceof AbstractRemoteResourceManagerConfiguration) {
                AbstractRemoteResourceManagerConfiguration remConfig = (AbstractRemoteResourceManagerConfiguration)rmConfig;
                Path rmPath = new Path(remConfig.getProxyServerPath());
                path = rmPath.removeLastSegments(1).append("sdm").toString();
            }
        }
        catch (CoreException coreException) {}
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", path);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", this.getAddress(configuration));
    }

    private String browseFile() {
        if (this.remoteServices != null) {
            IPath path;
            IRemoteFileManager fileManager = this.remoteServices.getFileManager(this.connection);
            if (fileManager != null && (path = fileManager.browseFile(this.getShell(), Messages.getString("SDMDebuggerPage.selectDebuggerExe"), this.fRMDebuggerPathText.getText())) != null) {
                return path.toString();
            }
        } else {
            FileDialog dialog = new FileDialog(this.getShell());
            dialog.setText(Messages.getString("SDMDebuggerPage.selectDebuggerExe"));
            dialog.setFileName(this.fRMDebuggerPathText.getText());
            return dialog.open();
        }
        return null;
    }

    private String getAddress(ILaunchConfigurationWorkingCopy configuration) {
        String rmId;
        String address;
        try {
            address = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", EMPTY_STRING);
            rmId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", EMPTY_STRING);
        }
        catch (CoreException coreException) {
            return EMPTY_STRING;
        }
        IResourceManagerControl rm = (IResourceManagerControl)PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
        if (rm != null) {
            IResourceManagerConfiguration rmConfig = rm.getConfiguration();
            if (this.resourceManager != rm) {
                this.resourceManager = rm;
                if (rmConfig instanceof AbstractRemoteResourceManagerConfiguration) {
                    AbstractRemoteResourceManagerConfiguration remConfig = (AbstractRemoteResourceManagerConfiguration)rmConfig;
                    this.remoteServices = PTPRemotePlugin.getDefault().getRemoteServices(remConfig.getRemoteServicesId());
                    if (this.remoteServices != null) {
                        this.connection = this.remoteServices.getConnectionManager().getConnection(remConfig.getConnectionName());
                        address = remConfig.testOption(2) ? this.connection.getAddress() : remConfig.getLocalAddress();
                    }
                } else {
                    address = "localhost";
                }
            }
        }
        return address;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }
}

