/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.ui.swt;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.ptp.remotetools.utils.ui.swt.ComboGroupItem;
import org.eclipse.ptp.remotetools.utils.ui.swt.ComboMold;
import org.eclipse.ptp.remotetools.utils.ui.swt.GenericControlGroup;
import org.eclipse.ptp.remotetools.utils.ui.swt.GenericControlMold;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboGroup
extends GenericControlGroup {
    public static final int MAX_SIZE = Combo.LIMIT;
    Combo combo;
    Vector comboItems = new Vector();

    public ComboGroup(Composite parent, GenericControlMold mold) {
        super(parent, mold);
        ComboMold cmold = (ComboMold)mold;
        for (ComboGroupItem item : cmold.items) {
            this.add(item);
        }
    }

    protected Control createCustomControl(int bitmask, GridData gd) {
        this.combo = (bitmask & ComboMold.EDITABLE) != 0 ? new Combo((Composite)this, 2048) : new Combo((Composite)this, 2056);
        return this.combo;
    }

    public Combo getCombo() {
        return this.combo;
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public String getSelectionId() {
        if (this.combo.getSelectionIndex() == -1) {
            return null;
        }
        return this.getItemUsingIndex(this.combo.getSelectionIndex()).getId();
    }

    public void setSelectionIndex(int index) {
        this.combo.select(index);
    }

    public void add(ComboGroupItem comboItem) {
        this.comboItems.add(comboItem);
        this.combo.add(comboItem.value);
    }

    public void add(ComboGroupItem comboItem, int index) {
        this.comboItems.add(index, comboItem);
        this.combo.add(comboItem.value, index);
    }

    public ComboGroupItem getItemUsingID(String id) {
        for (ComboGroupItem citem : this.comboItems) {
            if (!citem.id.equals(id)) continue;
            return citem;
        }
        return null;
    }

    public void selectIndexUsingID(String id) {
        Iterator it = this.comboItems.iterator();
        int index = 0;
        while (it.hasNext()) {
            ComboGroupItem citem = (ComboGroupItem)it.next();
            if (citem.id.equals(id)) {
                this.combo.select(index);
                return;
            }
            ++index;
        }
        if (this.comboItems.size() > 0) {
            this.combo.select(0);
        }
    }

    public ComboGroupItem getItemUsingIndex(int index) {
        if (index < 0 || this.comboItems.get(index) == null) {
            return new ComboGroupItem("", "");
        }
        return (ComboGroupItem)this.comboItems.get(index);
    }

    public ComboGroupItem getSelectedItem() {
        return this.getItemUsingIndex(this.combo.getSelectionIndex());
    }
}

