/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ptp.remotetools.core.AuthToken;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.internal.ssh.CipherTypes;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.osgi.framework.BundleContext;

public class RemotetoolsPlugin
extends Plugin {
    private static RemotetoolsPlugin plugin;
    public static final String CIPHER_3DES;
    public static final String CIPHER_AES128;
    public static final String CIPHER_AES192;
    public static final String CIPHER_AES256;
    public static final String CIPHER_BLOWFISH;
    public static final String CIPHER_DEFAULT;

    static {
        CIPHER_3DES = CipherTypes.CIPHER_3DES;
        CIPHER_AES128 = CipherTypes.CIPHER_AES128;
        CIPHER_AES192 = CipherTypes.CIPHER_AES192;
        CIPHER_AES256 = CipherTypes.CIPHER_AES256;
        CIPHER_BLOWFISH = CipherTypes.CIPHER_BLOWFISH;
        CIPHER_DEFAULT = CipherTypes.CIPHER_DEFAULT;
    }

    public RemotetoolsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static RemotetoolsPlugin getDefault() {
        return plugin;
    }

    public static IRemoteConnection createSSHConnection(AuthToken authToken, String hostname, int port, String cipherType, int timeout) {
        return new Connection(authToken, hostname, port, cipherType, timeout);
    }

    public static IRemoteConnection createSSHConnection(AuthToken authToken, String hostname, int port, String cipherType) {
        return new Connection(authToken, hostname, port, cipherType);
    }

    public static IRemoteConnection createSSHConnection(AuthToken authToken, String hostname) {
        return new Connection(authToken, hostname);
    }

    public static IRemoteConnection createSSHConnection(AuthToken authToken, String hostname, int port) {
        return new Connection(authToken, hostname, port);
    }

    public static Map getCipherTypesMap() {
        HashMap map = new HashMap(CipherTypes.getCipherTypesMap());
        return map;
    }
}

