/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.ui.widgets;

import java.util.Iterator;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringSetAttributeDefinition;
import org.eclipse.ptp.rm.ibm.pe.ui.widgets.ValidationState;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboRowWidget
implements ValidationState {
    private Label label;
    private Label nonDefaultMarker;
    private GridData gridData;
    private IAttributeDefinition<?, ?, ?> attrDef;
    private Combo widget;
    private String defaultValue;
    private EventMonitor eventMonitor;
    private int validationState;

    public ComboRowWidget(Composite parent, String id, IAttributeDefinition<?, ?, ?> def, boolean readOnly) {
        this.attrDef = def;
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = false;
        this.label = new Label(parent, 0);
        this.label.setText(this.attrDef.getName());
        this.label.setLayoutData((Object)this.gridData);
        this.nonDefaultMarker = new Label(parent, 0);
        this.nonDefaultMarker.setText(" ");
        this.widget = readOnly ? new Combo(parent, 12) : new Combo(parent, 4);
        Iterator iter = ((StringSetAttributeDefinition)def).getValues().iterator();
        while (iter.hasNext()) {
            this.widget.add((String)iter.next());
        }
        this.widget.setToolTipText(this.attrDef.getDescription());
        this.gridData = new GridData(768);
        this.gridData.horizontalSpan = 2;
        this.gridData.grabExcessHorizontalSpace = true;
        this.widget.setLayoutData((Object)this.gridData);
        this.widget.setData("ATTR_NAME", (Object)id);
        try {
            this.defaultValue = ((IAttribute)((Object)this.attrDef.create())).getValueAsString();
        }
        catch (IllegalValueException illegalValueException) {
            this.defaultValue = "";
        }
        this.eventMonitor = new EventMonitor();
        this.widget.addModifyListener((ModifyListener)this.eventMonitor);
        this.widget.addSelectionListener((SelectionListener)this.eventMonitor);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.widget.addSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.widget.addModifyListener(listener);
    }

    public String getValue() {
        return this.widget.getText().trim();
    }

    public void setValue(String value) {
        this.widget.setText(value);
    }

    public String getData(String key) {
        return (String)this.widget.getData(key);
    }

    public void setEnabled(boolean state) {
        this.widget.setEnabled(state);
    }

    public boolean isEnabled() {
        return this.widget.isEnabled();
    }

    protected void setDefaultStatus() {
        String value = this.widget.getText().trim();
        if (value.length() == 0 || value.equals(this.defaultValue)) {
            this.nonDefaultMarker.setText(" ");
        } else {
            this.nonDefaultMarker.setText("*");
        }
    }

    @Override
    public void resetValidationState() {
        this.validationState = 0;
    }

    @Override
    public void setFieldInError() {
        this.validationState = 2;
    }

    @Override
    public void setValidationRequired() {
        this.validationState = 1;
    }

    @Override
    public boolean isValidationRequired() {
        return this.validationState == 1 || this.validationState == 2;
    }

    @Override
    public boolean isMatchingWidget(Widget source) {
        return this.widget == source;
    }

    private class EventMonitor
    implements ModifyListener,
    SelectionListener {
        public void modifyText(ModifyEvent e) {
            ComboRowWidget.this.setDefaultStatus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ComboRowWidget.this.setDefaultStatus();
        }
    }
}

