/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.actions.GotoAction;
import org.eclipse.ptp.ui.actions.GotoDropDownAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;

public class ChangeSetAction
extends GotoDropDownAction {
    public static final String name = "Change Set";

    public ChangeSetAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_CHANGESET_NORMAL);
    }

    protected void createDropDownMenu(MenuManager dropDownMenuMgr) {
        String curID = this.view.getCurrentSetID();
        if (curID == null || curID.length() == 0) {
            return;
        }
        this.addAction(dropDownMenuMgr, "Root", "Root", curID, null);
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElement[] sets = setManager.getElements();
        if (sets.length > 1) {
            dropDownMenuMgr.add((IContributionItem)new Separator());
        }
        IElement[] iElementArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IElement set = iElementArray[n2];
            if (set instanceof IElementSet && !set.getID().equals("Root")) {
                this.addAction(dropDownMenuMgr, set.getID(), set.getID(), curID, null);
            }
            ++n2;
        }
    }

    protected void addAction(MenuManager dropDownMenuMgr, String e_name, String id, String curID, Object data) {
        InternalSetAction action = new InternalSetAction(e_name, id, this.view, this);
        action.setChecked(curID.equals(id));
        action.setEnabled(true);
        dropDownMenuMgr.add((IAction)action);
    }

    public void run(IElement[] elements) {
    }

    public void run() {
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElement[] sets = setManager.getElements();
        int i = 0;
        while (i < sets.length) {
            if (this.view.getCurrentSetID().equals(sets[i].getID())) {
                if (i + 1 < sets.length) {
                    this.run(null, (IElementSet)sets[i + 1]);
                    break;
                }
                this.run(null, (IElementSet)sets[0]);
                break;
            }
            ++i;
        }
    }

    public void run(IElement[] elements, IElementSet set) {
        this.view.selectSet(set);
        this.view.refresh(false);
    }

    public void run(IElement[] elements, String id, Object data) {
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        this.run(elements, (IElementSet)setManager.getElementByID(id));
    }

    private class InternalSetAction
    extends GotoAction {
        public InternalSetAction(String name, String id, AbstractParallelElementView view, GotoDropDownAction action) {
            super(name, id, view, action, null);
        }
    }
}

