/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.hover;

import org.eclipse.jface.text.TextPresentation;
import org.eclipse.ptp.internal.ui.hover.IconHoverPresenter;
import org.eclipse.ptp.ui.hover.IIconInformationControl;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DefaultInformationControl
implements IIconInformationControl,
DisposeListener {
    public static final int SHELL_DEFAULT_WIDTH = 400;
    public static final int SHELL_DEFAULT_HEIGHT = 200;
    private static final int OUTER_BORDER = 1;
    private static final int INNER_BORDER = 1;
    private Shell fShell;
    private StyledText fText;
    private IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private Font fHeaderTextFont;
    private Label headerField = null;
    private ScrolledComposite sc = null;
    private boolean showDetails = false;

    public DefaultInformationControl(Shell parent, boolean showDetails) {
        this(parent, showDetails, 64);
    }

    public DefaultInformationControl(Shell parent, boolean showDetails, int style) {
        this(parent, 12, showDetails, style, new IconHoverPresenter(false), false);
    }

    public DefaultInformationControl(Shell parent) {
        this(parent, false);
    }

    public DefaultInformationControl(Shell parent, int style, IInformationPresenter presenter, boolean enableKey) {
        this(parent, 12, true, style, presenter, enableKey);
    }

    public DefaultInformationControl(Shell parent, int shellStyle, boolean showDetails, int style, IInformationPresenter presenter, boolean enableKey) {
        int border;
        this.showDetails = showDetails;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (shellStyle & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        this.fShell.setLayout((Layout)layout);
        this.fShell.setLayoutData((Object)new GridData(1808));
        this.sc = new ScrolledComposite((Composite)this.fShell, 768);
        this.sc.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)this.sc, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = showDetails ? 10 : 0;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setForeground(display.getSystemColor(28));
        composite.setBackground(display.getSystemColor(29));
        this.sc.setContent((Control)composite);
        this.sc.setExpandVertical(true);
        this.sc.setExpandHorizontal(true);
        this.sc.setAlwaysShowScrollBars(true);
        Composite hdComposite = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        hdComposite.setLayout((Layout)layout);
        hdComposite.setLayoutData((Object)new GridData(1808));
        hdComposite.setForeground(composite.getForeground());
        hdComposite.setBackground(composite.getBackground());
        this.headerField = new Label(hdComposite, 16384);
        this.createHeadLabel(this.headerField);
        if (showDetails) {
            if (enableKey) {
                Label labelField = new Label(hdComposite, 131072);
                labelField.setText("Press ESC to close");
                this.createHeadLabel(labelField);
            }
            Label separator = new Label(composite, 259);
            separator.setLayoutData((Object)new GridData(768));
            this.fText = new StyledText(composite, 0xA | style);
            if ((style & 0x40) != 0) {
                this.fMaxWidth = 200;
            }
            this.fText.setCaret(null);
            GridData gd = new GridData(1809);
            gd.horizontalIndent = 1;
            gd.verticalIndent = 1;
            this.fText.setLayoutData((Object)gd);
            this.fText.setForeground(composite.getForeground());
            this.fText.setBackground(composite.getBackground());
            this.fText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    DefaultInformationControl.this.close();
                }
            });
            if (enableKey) {
                this.fText.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\u001b') {
                            DefaultInformationControl.this.close();
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
            }
            this.fPresenter = presenter;
        }
        this.addDisposeListener(this);
    }

    private void close() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        }
    }

    private void createHeadLabel(Label labelField) {
        Font font = labelField.getFont();
        if (this.fHeaderTextFont == null) {
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fHeaderTextFont = new Font((Device)labelField.getDisplay(), fontDatas);
        }
        labelField.setFont(this.fHeaderTextFont);
        labelField.setLayoutData((Object)new GridData(802));
        labelField.setForeground(labelField.getParent().getForeground());
        labelField.setBackground(labelField.getParent().getBackground());
    }

    public void setHeader(String header) {
        if (this.headerField != null) {
            this.headerField.setText(String.valueOf(header) + " ");
        }
    }

    public void setInformation(String content) {
        if (this.fPresenter == null) {
            this.fText.setText(content);
        } else {
            this.fPresentation.clear();
            content = this.fPresenter.updatePresentation(this.fShell.getDisplay(), content, this.fPresentation, this.fMaxWidth, this.fMaxHeight);
            if (content != null) {
                this.fText.setText(content);
                TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
            } else {
                this.fText.setText("");
            }
        }
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fHeaderTextFont != null && !this.fHeaderTextFont.isDisposed()) {
            this.fHeaderTextFont.dispose();
        }
        this.fShell = null;
        this.fText = null;
        this.fHeaderTextFont = null;
    }

    public void setSize(int width, int height) {
        int new_width;
        int n = new_width = this.showDetails ? width + 75 : width;
        if (width > 400 || height > 200) {
            this.sc.setMinSize(width, height);
            this.sc.getHorizontalBar().setVisible(width > 400);
            this.sc.getVerticalBar().setVisible(height > 200);
            int n2 = new_width = width > 400 ? 400 : new_width;
            int new_height = height > 200 ? 200 : (width > 400 ? this.sc.getHorizontalBar().getSize().y + height : height);
            this.fShell.setSize(new_width + 5, new_height + 2);
        } else {
            int min_h = this.sc.getHorizontalBar().getSize().y;
            if (height <= min_h) {
                height = min_h + 1;
            }
            this.sc.setAlwaysShowScrollBars(false);
            this.fShell.setSize(new_width + 5, height + 2);
        }
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        return this.sc.getContent().computeSize(-1, -1);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        if (this.showDetails && this.fText != null) {
            this.fText.setFocus();
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public Point getShellSize() {
        Point size = this.computeSizeHint();
        this.setSize(size.x, size.y);
        if (size.x > 400) {
            size.x = 400;
        }
        if (size.y > 200) {
            size.y = 200;
        }
        return size;
    }

    public boolean isWrap() {
        return this.fMaxWidth > -1;
    }

    public static interface IInformationPresenter {
        public String updatePresentation(Display var1, String var2, TextPresentation var3, int var4, int var5);
    }
}

