/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.events.IChangedJobEvent;
import org.eclipse.ptp.core.elements.events.IChangedMachineEvent;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.IChangedQueueEvent;
import org.eclipse.ptp.core.elements.events.INewJobEvent;
import org.eclipse.ptp.core.elements.events.INewMachineEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.INewQueueEvent;
import org.eclipse.ptp.core.elements.events.IRemoveJobEvent;
import org.eclipse.ptp.core.elements.events.IRemoveMachineEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.events.IRemoveQueueEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.elements.listeners.IQueueChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.events.IChangedResourceManagerEvent;
import org.eclipse.ptp.core.events.INewResourceManagerEvent;
import org.eclipse.ptp.core.events.IRemoveResourceManagerEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.internal.ui.actions.JobFocusAction;
import org.eclipse.ptp.internal.ui.actions.RemoveAllTerminatedAction;
import org.eclipse.ptp.internal.ui.actions.TerminateJobAction;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.managers.JobManager;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.utils.DebugUtil;
import org.eclipse.ptp.ui.views.AbstractParallelSetView;
import org.eclipse.ptp.ui.views.IToolTipProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.progress.WorkbenchJob;

public class ParallelJobsView
extends AbstractParallelSetView
implements ISelectionProvider {
    private boolean jobFocus = true;
    private final IModelManagerChildListener modelManagerListener = new MMChildListener();
    private final IResourceManagerChildListener resourceManagerListener = new RMChildListener();
    private final IJobChildListener jobChildListener = new JobChildListener();
    private final IQueueChildListener queueChildListener = new QueueChildListener();
    private boolean debug = DebugUtil.JOBS_VIEW_TRACING;
    private ISelection selection = null;
    private ListenerList listeners = new ListenerList();
    private Action jobFocusAction = null;
    protected String cur_selected_element_id = "";
    protected Menu jobPopupMenu = null;
    protected SashForm sashForm = null;
    protected TableViewer jobTableViewer = null;
    protected Composite elementViewComposite = null;
    protected JobViewUpdateWorkbenchJob jobViewUpdateJob = new JobViewUpdateWorkbenchJob();
    protected ParallelAction terminateAllAction = null;

    public ParallelJobsView() {
        this(PTPUIPlugin.getDefault().getJobManager());
    }

    public ParallelJobsView(IManager manager) {
        super(manager);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void changeJobRefresh(IPJob job) {
        this.changeJobRefresh(job, false);
    }

    public void changeJobRefresh(IPJob job, boolean force) {
        IPJob cur_job = this.getJobManager().getJob();
        StructuredSelection selection = null;
        if (cur_job == null && job != null) {
            this.doChangeJob(job);
            selection = new StructuredSelection((Object)job);
        } else if (cur_job != null && job == null) {
            this.doChangeJob((IPJob)null);
            selection = new StructuredSelection();
        } else if (cur_job != null && job != null) {
            if (!cur_job.getID().equals(job.getID())) {
                this.doChangeJob(job);
            }
            selection = new StructuredSelection((Object)job);
        } else {
            selection = new StructuredSelection();
        }
        if (this.isVisible()) {
            this.jobViewUpdateJob.schedule((ISelection)selection, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IModelManager mm;
        IModelManager iModelManager = mm = PTPCorePlugin.getDefault().getModelManager();
        synchronized (iModelManager) {
            IResourceManager[] iResourceManagerArray = mm.getUniverse().getResourceManagers();
            int n = iResourceManagerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceManager rm = iResourceManagerArray[n2];
                IPQueue[] iPQueueArray = rm.getQueues();
                int n3 = iPQueueArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPQueue queue = iPQueueArray[n4];
                    IPJob[] iPJobArray = queue.getJobs();
                    int n5 = iPJobArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IPJob job = iPJobArray[n6];
                        job.removeChildListener(this.jobChildListener);
                        ++n6;
                    }
                    queue.removeChildListener(this.queueChildListener);
                    ++n4;
                }
                rm.removeChildListener(this.resourceManagerListener);
                ++n2;
            }
            mm.removeListener(this.modelManagerListener);
        }
        this.elementViewComposite.dispose();
        super.dispose();
    }

    public void doChangeJob(final IPJob job) {
        this.syncExec(new Runnable(){

            public void run() {
                ParallelJobsView.this.selectJob(job);
                ParallelJobsView.this.update();
            }
        });
    }

    public void doChangeJob(String job_id) {
        this.doChangeJob(((JobManager)this.manager).findJobById(job_id));
    }

    public void doubleClick(IElement element) {
        this.openProcessViewer(this.getJobManager().findProcess(element.getID()));
    }

    public synchronized String getCurrentID() {
        IPJob job = this.getJobManager().getJob();
        if (job != null) {
            return job.getID();
        }
        return "";
    }

    public Image getImage(int index1, int index2) {
        return ParallelImages.procImages[index1][index2];
    }

    public IPQueue getQueue() {
        return this.getJobManager().getQueue();
    }

    public String getQueueID() {
        IPQueue queue = this.getQueue();
        if (queue != null) {
            return queue.getID();
        }
        return "";
    }

    public String getRulerIndex(Object obj, int index) {
        if (obj instanceof IElement) {
            return ((IElement)obj).getName();
        }
        return super.getRulerIndex(obj, index);
    }

    public ISelection getSelection() {
        if (this.selection == null) {
            return StructuredSelection.EMPTY;
        }
        return this.selection;
    }

    public String[] getToolTipText(Object obj) {
        IElementHandler setManager = this.getCurrentElementHandler();
        if (obj == null || !(obj instanceof IPProcess) || setManager == null || this.cur_element_set == null) {
            return IToolTipProvider.NO_TOOLTIP;
        }
        IPProcess proc = (IPProcess)obj;
        StringBuffer buffer = new StringBuffer();
        String num = proc.getProcessIndex();
        if (num != null) {
            buffer.append("Index: " + num);
            buffer.append("\n");
        }
        buffer.append("PID: " + proc.getPid());
        IElementSet[] sets = setManager.getSetsWithElement(proc.getID());
        if (sets.length > 1) {
            buffer.append("\nSet: ");
        }
        int i = 1;
        while (i < sets.length) {
            buffer.append(sets[i].getID());
            if (i < sets.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return new String[]{buffer.toString()};
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void repaint(boolean all) {
        if (all && !this.jobTableViewer.getTable().isDisposed()) {
            this.jobTableViewer.refresh(true);
        }
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = event.getSelection();
        this.setSelection(this.selection);
    }

    public void setFocus() {
        super.setFocus();
        IPJob job = this.getJobManager().getJob();
        if (job == null) {
            this.changeJobRefresh(null);
        }
    }

    public void setJobFocus(boolean focus) {
        this.jobFocus = focus;
    }

    public void setSelection(ISelection selection) {
        final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(e);
                }
            });
            ++i;
        }
    }

    public void updateAction() {
        super.updateAction();
        if (this.terminateAllAction != null) {
            ISelection selection = this.jobTableViewer.getSelection();
            if (selection.isEmpty()) {
                this.terminateAllAction.setEnabled(false);
            } else {
                IPJob job = (IPJob)((IStructuredSelection)selection).getFirstElement();
                this.terminateAllAction.setEnabled(!job.isDebug() && !job.isTerminated());
            }
        }
    }

    public void updateJobSet() {
        IElementHandler setManager = this.getCurrentElementHandler();
        this.selectSet(setManager == null ? null : setManager.getSetRoot());
    }

    protected Object convertElementObject(IElement element) {
        if (element == null) {
            return null;
        }
        return this.getJobManager().findProcess(element.getID());
    }

    protected void createJobContextMenu() {
        MenuManager menuMgr = new MenuManager("#jobpopupmenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("actiongroup"));
                manager.add((IContributionItem)new Separator("emptygroup"));
                ParallelJobsView.this.fillJobContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.jobTableViewer.getTable());
        this.jobTableViewer.getTable().setMenu(menu);
    }

    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        this.terminateAllAction = new TerminateJobAction(this);
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.terminateAllAction);
        this.jobFocusAction = new JobFocusAction(this);
        toolBarMgr.add((IContributionItem)new Separator("jobgroup"));
        toolBarMgr.appendToGroup("jobgroup", (IAction)this.jobFocusAction);
        super.buildInToolBarActions(toolBarMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createView(Composite parent) {
        IModelManager mm;
        parent.setLayout((Layout)new FillLayout(512));
        parent.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayout((Layout)new FillLayout(512));
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.jobTableViewer = new TableViewer((Composite)this.sashForm, 2052);
        this.jobTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.jobTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IPJob) {
                    IPJob job = (IPJob)element;
                    return ParallelImages.jobImages[job.getState().ordinal()][job.isDebug() ? 1 : 0];
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IPJob) {
                    return ((IPJob)element).getName();
                }
                return "";
            }
        });
        this.jobTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof JobManager) {
                    return ((JobManager)inputElement).getJobs();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.jobTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object j1, Object j2) {
                return ((IPJob)j1).getName().compareTo(((IPJob)j2).getName());
            }
        });
        this.jobTableViewer.setInput((Object)this.manager);
        this.jobTableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ISelection selection = ParallelJobsView.this.jobTableViewer.getSelection();
                TableItem item = ParallelJobsView.this.jobTableViewer.getTable().getItem(new Point(e.x, e.y));
                if (item == null && !selection.isEmpty()) {
                    ParallelJobsView.this.jobTableViewer.getTable().deselectAll();
                    ParallelJobsView.this.doChangeJob((IPJob)null);
                } else if (item != null) {
                    IPJob job = (IPJob)item.getData();
                    if (job == null) {
                        ParallelJobsView.this.doChangeJob((IPJob)null);
                    } else if (selection.isEmpty()) {
                        ParallelJobsView.this.doChangeJob(job);
                    } else {
                        String cur_id = ParallelJobsView.this.getCurrentID();
                        if (cur_id == null || !cur_id.equals(job.getID())) {
                            ParallelJobsView.this.doChangeJob(job);
                        }
                    }
                    ParallelJobsView.this.update();
                }
            }
        });
        this.jobTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.createJobContextMenu();
        this.elementViewComposite = this.createElementView((Composite)this.sashForm);
        this.jobTableViewer.getTable().setVisible(true);
        this.elementViewComposite.setVisible(true);
        this.sashForm.setWeights(new int[]{1, 2});
        IModelManager iModelManager = mm = PTPCorePlugin.getDefault().getModelManager();
        synchronized (iModelManager) {
            IResourceManager[] iResourceManagerArray = mm.getUniverse().getResourceManagers();
            int n = iResourceManagerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceManager rm = iResourceManagerArray[n2];
                rm.addChildListener(this.resourceManagerListener);
                ++n2;
            }
            mm.addListener(this.modelManagerListener);
        }
    }

    protected void fillJobContextMenu(IMenuManager menuManager) {
        RemoveAllTerminatedAction removeAllTerminatedAction = new RemoveAllTerminatedAction(this);
        removeAllTerminatedAction.setEnabled(this.getJobManager().hasStoppedJob());
        menuManager.add((IAction)removeAllTerminatedAction);
    }

    protected JobManager getJobManager() {
        return (JobManager)this.manager;
    }

    protected void initialElement() {
        IPUniverse universe = PTPCorePlugin.getDefault().getUniverse();
        IResourceManager[] iResourceManagerArray = universe.getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            IPQueue[] iPQueueArray = rm.getQueues();
            int n3 = iPQueueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPQueue queue = iPQueueArray[n4];
                queue.addChildListener(this.queueChildListener);
                ++n4;
            }
            ++n2;
        }
        this.manager.initial(universe);
        this.changeJobRefresh(null, true);
    }

    protected void initialView() {
        this.initialElement();
    }

    protected void refreshJobView() {
        this.syncExec(new Runnable(){

            public void run() {
                if (!ParallelJobsView.this.jobTableViewer.getTable().isDisposed()) {
                    ParallelJobsView.this.jobTableViewer.refresh(true);
                }
            }
        });
    }

    protected void selectJob(IPJob job) {
        IPJob old = this.getJobManager().getJob();
        if (old != null) {
            old.removeChildListener(this.jobChildListener);
        }
        if (job != null) {
            job.addChildListener(this.jobChildListener);
        }
        this.getJobManager().setJob(job);
        this.updateJobSet();
    }

    private final class JobChildListener
    implements IJobChildListener {
        private JobChildListener() {
        }

        public void handleEvent(IChangedProcessEvent e) {
            if (e.getSource() instanceof IPJob) {
                if (ParallelJobsView.this.debug) {
                    System.err.println("----------------- IJobChildListener - IChangedProcessEvent: " + this);
                }
                if (!((IPJob)e.getSource()).isDebug()) {
                    ParallelJobsView.this.refresh(true);
                }
            }
        }

        public void handleEvent(INewProcessEvent e) {
            if (e.getSource() instanceof IPJob) {
                if (ParallelJobsView.this.debug) {
                    System.err.println("----------------- IJobChildListener - INewProcessEvent: " + this);
                }
                for (IPProcess proc : e.getProcesses()) {
                    ParallelJobsView.this.getJobManager().addProcess(proc);
                }
                boolean isCurrent = e.getSource().getID().equals(ParallelJobsView.this.getCurrentID());
                if (isCurrent) {
                    ParallelJobsView.this.updateJobSet();
                    ParallelJobsView.this.changeJobRefresh((IPJob)e.getSource());
                }
            }
        }

        public void handleEvent(IRemoveProcessEvent e) {
            if (e.getSource() instanceof IPJob) {
                if (ParallelJobsView.this.debug) {
                    System.err.println("----------------- IJobChildListener - IRemoveProcessEvent: " + this);
                }
                boolean isCurrent = e.getSource().getID().equals(ParallelJobsView.this.getCurrentID());
                for (IPProcess proc : e.getProcesses()) {
                    ParallelJobsView.this.getJobManager().removeProcess(proc);
                }
                if (isCurrent) {
                    ParallelJobsView.this.updateJobSet();
                    ParallelJobsView.this.changeJobRefresh((IPJob)e.getSource());
                }
            }
        }
    }

    class JobViewUpdateWorkbenchJob
    extends WorkbenchJob {
        private final ReentrantLock waitLock;
        private List<ISelection> refreshJobList;

        public JobViewUpdateWorkbenchJob() {
            super("Refreshing job view...");
            this.waitLock = new ReentrantLock();
            this.refreshJobList = new ArrayList<ISelection>();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.size() == 0) {
                return Status.CANCEL_STATUS;
            }
            ISelection selection = this.getLastJobSelection();
            if (ParallelJobsView.this.debug) {
                System.err.println("============= JobViewUpdateWorkbenchJob refresh: " + selection);
            }
            if (!ParallelJobsView.this.jobTableViewer.getTable().isDisposed()) {
                ParallelJobsView.this.jobTableViewer.setSelection(selection, true);
                ParallelJobsView.this.jobTableViewer.refresh(true);
            }
            ISelection lastSelection = this.getLastJobSelection();
            this.waitLock.lock();
            try {
                this.refreshJobList.clear();
                if (!selection.equals(lastSelection)) {
                    this.refreshJobList.add(lastSelection);
                    this.schedule();
                }
            }
            finally {
                this.waitLock.unlock();
            }
            return Status.OK_STATUS;
        }

        public void schedule(ISelection selection, boolean force) {
            this.waitLock.lock();
            try {
                if (force) {
                    this.refreshJobList.clear();
                }
                if (!this.refreshJobList.contains(selection)) {
                    this.refreshJobList.add(selection);
                }
            }
            finally {
                this.waitLock.unlock();
            }
            this.schedule();
        }

        public boolean shouldSchedule() {
            int size = this.size();
            if (ParallelJobsView.this.debug) {
                System.err.println("============= JobViewUpdateWorkbenchJob: " + this.refreshJobList.size());
            }
            return size == 1;
        }

        private ISelection getLastJobSelection() {
            this.waitLock.lock();
            try {
                ISelection iSelection = this.refreshJobList.get(this.refreshJobList.size() - 1);
                return iSelection;
            }
            finally {
                this.waitLock.unlock();
            }
        }

        private int size() {
            this.waitLock.lock();
            try {
                int n = this.refreshJobList.size();
                return n;
            }
            finally {
                this.waitLock.unlock();
            }
        }
    }

    private final class MMChildListener
    implements IModelManagerChildListener {
        private MMChildListener() {
        }

        public void handleEvent(IChangedResourceManagerEvent e) {
        }

        public void handleEvent(INewResourceManagerEvent e) {
            IResourceManager rm = e.getResourceManager();
            rm.addChildListener(ParallelJobsView.this.resourceManagerListener);
        }

        public void handleEvent(IRemoveResourceManagerEvent e) {
            e.getResourceManager().removeChildListener(ParallelJobsView.this.resourceManagerListener);
        }
    }

    private final class QueueChildListener
    implements IQueueChildListener {
        private QueueChildListener() {
        }

        public void handleEvent(IChangedJobEvent e) {
            ParallelJobsView.this.refreshJobView();
        }

        public void handleEvent(INewJobEvent e) {
            if (ParallelJobsView.this.debug) {
                System.err.println("----------------- QueueChildListener - INewJobEvent: " + this);
            }
            IPJob lastJob = null;
            for (IPJob job : e.getJobs()) {
                ParallelJobsView.this.getJobManager().createElementHandler(job);
                lastJob = job;
            }
            if (lastJob != null) {
                if (ParallelJobsView.this.jobFocus) {
                    ParallelJobsView.this.changeJobRefresh(lastJob, true);
                } else {
                    ParallelJobsView.this.refreshJobView();
                }
            }
        }

        public void handleEvent(IRemoveJobEvent e) {
            if (ParallelJobsView.this.debug) {
                System.err.println("----------------- QueueChildListener - IRemoveJobEvent: " + this);
            }
            for (IPJob job : e.getJobs()) {
                ParallelJobsView.this.getJobManager().removeJob(job);
            }
            ParallelJobsView.this.changeJobRefresh(null, true);
        }
    }

    private final class RMChildListener
    implements IResourceManagerChildListener {
        private RMChildListener() {
        }

        public void handleEvent(IChangedMachineEvent e) {
        }

        public void handleEvent(IChangedQueueEvent e) {
        }

        public void handleEvent(INewMachineEvent e) {
        }

        public void handleEvent(INewQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                queue.addChildListener(ParallelJobsView.this.queueChildListener);
            }
        }

        public void handleEvent(IRemoveMachineEvent e) {
        }

        public void handleEvent(IRemoveQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                queue.removeChildListener(ParallelJobsView.this.queueChildListener);
            }
        }
    }
}

