/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.elements.events.IChangedJobEvent;
import org.eclipse.ptp.core.elements.events.IChangedMachineEvent;
import org.eclipse.ptp.core.elements.events.IChangedNodeEvent;
import org.eclipse.ptp.core.elements.events.IChangedQueueEvent;
import org.eclipse.ptp.core.elements.events.IMachineChangeEvent;
import org.eclipse.ptp.core.elements.events.INewJobEvent;
import org.eclipse.ptp.core.elements.events.INewMachineEvent;
import org.eclipse.ptp.core.elements.events.INewNodeEvent;
import org.eclipse.ptp.core.elements.events.INewQueueEvent;
import org.eclipse.ptp.core.elements.events.IQueueChangeEvent;
import org.eclipse.ptp.core.elements.events.IRemoveJobEvent;
import org.eclipse.ptp.core.elements.events.IRemoveMachineEvent;
import org.eclipse.ptp.core.elements.events.IRemoveNodeEvent;
import org.eclipse.ptp.core.elements.events.IRemoveQueueEvent;
import org.eclipse.ptp.core.elements.events.IResourceManagerChangeEvent;
import org.eclipse.ptp.core.elements.events.IResourceManagerErrorEvent;
import org.eclipse.ptp.core.elements.listeners.IMachineChildListener;
import org.eclipse.ptp.core.elements.listeners.IMachineListener;
import org.eclipse.ptp.core.elements.listeners.IQueueChildListener;
import org.eclipse.ptp.core.elements.listeners.IQueueListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerListener;
import org.eclipse.ptp.core.events.IChangedResourceManagerEvent;
import org.eclipse.ptp.core.events.INewResourceManagerEvent;
import org.eclipse.ptp.core.events.IRemoveResourceManagerEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.rmsystem.IResourceManagerMenuContribution;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.ptp.ui.actions.AddResourceManagerAction;
import org.eclipse.ptp.ui.actions.EditResourceManagerAction;
import org.eclipse.ptp.ui.actions.RemoveResourceManagersAction;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public class ResourceManagerView
extends ViewPart {
    private final Set<IResourceManager> resourceManagers = new HashSet<IResourceManager>();
    private TreeViewer viewer;
    private RemoveResourceManagersAction removeResourceManagerAction;
    private AddResourceManagerAction addResourceManagerAction;
    private EditResourceManagerAction editResourceManagerAction;
    private final MMChildListener mmChildListener = new MMChildListener();
    private final RMListener rmListener = new RMListener();
    private final RMChildListener rmChildListener = new RMChildListener();

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 2);
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)PTPCorePlugin.getDefault().getUniverse());
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IResourceManagerControl rm;
                ITreeSelection selection = (ITreeSelection)ResourceManagerView.this.viewer.getSelection();
                if (!selection.isEmpty() && (rm = (IResourceManagerControl)selection.getFirstElement()).getState() == ResourceManagerAttributes.State.STOPPED) {
                    ResourceManagerView.this.editResourceManagerAction.setResourceManager(rm);
                    ResourceManagerView.this.editResourceManagerAction.run();
                }
            }

            public void mouseDown(MouseEvent e) {
                ISelection selection = ResourceManagerView.this.viewer.getSelection();
                TreeItem item = ResourceManagerView.this.viewer.getTree().getItem(new Point(e.x, e.y));
                if (item == null && !selection.isEmpty()) {
                    ResourceManagerView.this.viewer.getTree().deselectAll();
                }
            }
        });
        IModelManager mm = PTPCorePlugin.getDefault().getModelManager();
        IResourceManager[] iResourceManagerArray = mm.getUniverse().getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            rm.addElementListener((IResourceManagerListener)this.rmListener);
            ++n2;
        }
        mm.addListener((IModelManagerChildListener)this.mmChildListener);
    }

    public synchronized void dispose() {
        PTPCorePlugin.getDefault().getModelManager().removeListener((IModelManagerChildListener)this.mmChildListener);
        for (IResourceManager resourceManager : this.resourceManagers) {
            resourceManager.removeElementListener((IResourceManagerListener)this.rmListener);
            resourceManager.removeChildListener((IResourceManagerChildListener)this.rmChildListener);
        }
        this.resourceManagers.clear();
        this.rmChildListener.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createContextMenu() {
        Shell shell = this.getSite().getShell();
        this.addResourceManagerAction = new AddResourceManagerAction(shell);
        this.removeResourceManagerAction = new RemoveResourceManagersAction(shell);
        this.editResourceManagerAction = new EditResourceManagerAction(shell);
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResourceManagerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        boolean inContextForRM;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        manager.add((IAction)this.addResourceManagerAction);
        Object[] selectedObjects = selection.toArray();
        boolean inContextForEditRM = inContextForRM = selection.size() > 0;
        boolean inContextForRemoveRM = inContextForRM;
        int i = 0;
        while (i < selectedObjects.length) {
            if (!(selectedObjects[i] instanceof IResourceManagerMenuContribution)) {
                inContextForRM = false;
                inContextForEditRM = false;
                inContextForRemoveRM = false;
                break;
            }
            IResourceManagerMenuContribution menuContrib = (IResourceManagerMenuContribution)selectedObjects[i];
            IResourceManagerControl rm = (IResourceManagerControl)menuContrib.getAdapter(IResourceManagerControl.class);
            if (rm.getState() != ResourceManagerAttributes.State.STOPPED) {
                inContextForEditRM = false;
                inContextForRemoveRM = false;
            }
            ++i;
        }
        manager.add((IAction)this.removeResourceManagerAction);
        this.removeResourceManagerAction.setEnabled(inContextForRemoveRM);
        if (inContextForRemoveRM) {
            IResourceManagerControl[] rmManagers = new IResourceManagerControl[selection.size()];
            int i2 = 0;
            while (i2 < rmManagers.length) {
                IResourceManagerMenuContribution menuContrib = (IResourceManagerMenuContribution)selectedObjects[i2];
                rmManagers[i2] = (IResourceManagerControl)menuContrib.getAdapter(IResourceManagerControl.class);
                ++i2;
            }
            this.removeResourceManagerAction.setResourceManager(rmManagers);
        }
        manager.add((IAction)this.editResourceManagerAction);
        this.editResourceManagerAction.setEnabled(inContextForEditRM);
        if (inContextForEditRM) {
            IResourceManagerMenuContribution menuContrib = (IResourceManagerMenuContribution)selectedObjects[0];
            IResourceManagerControl rmManager = (IResourceManagerControl)menuContrib.getAdapter(IResourceManagerControl.class);
            this.editResourceManagerAction.setResourceManager(rmManager);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private void refreshViewer(final IPElement element) {
        SafeRunnable safeRunnable = new SafeRunnable(){

            public void run() throws Exception {
                ResourceManagerView.this.viewer.refresh((Object)element);
            }
        };
        UIUtils.safeRunAsyncInUIThread((ISafeRunnable)safeRunnable);
    }

    private void updateViewer(final IPElement element) {
        SafeRunnable safeRunnable = new SafeRunnable(){

            public void run() throws Exception {
                ResourceManagerView.this.viewer.update((Object)element, null);
            }
        };
        UIUtils.safeRunAsyncInUIThread((ISafeRunnable)safeRunnable);
    }

    private final class MMChildListener
    implements IModelManagerChildListener {
        private MMChildListener() {
        }

        public void handleEvent(IChangedResourceManagerEvent e) {
        }

        public synchronized void handleEvent(INewResourceManagerEvent e) {
            IResourceManager resourceManager = e.getResourceManager();
            ResourceManagerView.this.resourceManagers.add(resourceManager);
            resourceManager.addElementListener((IResourceManagerListener)ResourceManagerView.this.rmListener);
            resourceManager.addChildListener((IResourceManagerChildListener)ResourceManagerView.this.rmChildListener);
            UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ResourceManagerView.this.refreshViewer((IPElement)PTPCorePlugin.getDefault().getUniverse());
                }
            });
        }

        public synchronized void handleEvent(IRemoveResourceManagerEvent e) {
            IResourceManager resourceManager = e.getResourceManager();
            ResourceManagerView.this.resourceManagers.remove(resourceManager);
            resourceManager.removeElementListener((IResourceManagerListener)ResourceManagerView.this.rmListener);
            resourceManager.removeChildListener((IResourceManagerChildListener)ResourceManagerView.this.rmChildListener);
            ResourceManagerView.this.rmChildListener.removeListeners(resourceManager);
            UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ResourceManagerView.this.refreshViewer((IPElement)PTPCorePlugin.getDefault().getUniverse());
                }
            });
        }
    }

    private final class MachineListener
    implements IMachineChildListener,
    IMachineListener {
        private MachineListener() {
        }

        public void handleEvent(IChangedNodeEvent e) {
            ResourceManagerView.this.updateViewer((IPElement)e.getSource());
        }

        public void handleEvent(IMachineChangeEvent e) {
            ResourceManagerView.this.updateViewer((IPElement)e.getSource());
        }

        public void handleEvent(IRemoveNodeEvent e) {
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }

        public void handleEvent(INewNodeEvent e) {
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }
    }

    private final class QueueListener
    implements IQueueListener,
    IQueueChildListener {
        private QueueListener() {
        }

        public void handleEvent(INewJobEvent e) {
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }

        public void handleEvent(IChangedJobEvent e) {
            ResourceManagerView.this.updateViewer((IPElement)e.getSource());
        }

        public void handleEvent(IQueueChangeEvent e) {
            ResourceManagerView.this.updateViewer((IPElement)e.getSource());
        }

        public void handleEvent(IRemoveJobEvent e) {
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }
    }

    private final class RMChildListener
    implements IResourceManagerChildListener {
        private final MachineListener machineListener;
        private QueueListener queueListener;
        private final Set<IPMachine> machines;
        private final Set<IPQueue> queues;

        private RMChildListener() {
            this.machineListener = new MachineListener();
            this.queueListener = new QueueListener();
            this.machines = new HashSet<IPMachine>();
            this.queues = new HashSet<IPQueue>();
        }

        public synchronized void dispose() {
            for (IPMachine machine : this.machines) {
                this.removeListeners(machine);
            }
            this.machines.clear();
            for (IPQueue queue : this.queues) {
                this.removeListeners(queue);
            }
            this.queues.clear();
        }

        public synchronized void handleEvent(INewMachineEvent e) {
            for (IPMachine machine : e.getMachines()) {
                this.machines.add(machine);
                this.addListeners(machine);
            }
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }

        public void handleEvent(INewQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                this.queues.add(queue);
                this.addListeners(queue);
            }
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }

        public void handleEvent(IChangedMachineEvent e) {
            ResourceManagerView.this.updateViewer((IPElement)e.getSource());
        }

        public void handleEvent(IChangedQueueEvent e) {
            ResourceManagerView.this.updateViewer((IPElement)e.getSource());
        }

        public synchronized void handleEvent(IRemoveMachineEvent e) {
            for (IPMachine machine : e.getMachines()) {
                this.machines.remove(machine);
                this.removeListeners(machine);
            }
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }

        public void handleEvent(IRemoveQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                this.queues.remove(queue);
                this.removeListeners(queue);
            }
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }

        public synchronized void removeListeners(IResourceManager resourceManager) {
            List<IPMachine> removeMachines = Arrays.asList(resourceManager.getMachines());
            removeMachines.retainAll(this.machines);
            for (IPMachine machine : removeMachines) {
                this.removeListeners(machine);
            }
            this.machines.removeAll(removeMachines);
            List<IPQueue> removeQueues = Arrays.asList(resourceManager.getQueues());
            removeQueues.retainAll(this.queues);
            for (IPQueue queue : removeQueues) {
                this.removeListeners(queue);
            }
            this.queues.removeAll(removeQueues);
        }

        private void addListeners(IPMachine machine) {
            machine.addElementListener((IMachineListener)this.machineListener);
            machine.addChildListener((IMachineChildListener)this.machineListener);
        }

        private void removeListeners(IPMachine machine) {
            machine.removeElementListener((IMachineListener)this.machineListener);
            machine.removeChildListener((IMachineChildListener)this.machineListener);
        }

        private void addListeners(IPQueue queue) {
            queue.addElementListener((IQueueListener)this.queueListener);
            queue.addChildListener((IQueueChildListener)this.queueListener);
        }

        private void removeListeners(IPQueue queue) {
            queue.removeElementListener((IQueueListener)this.queueListener);
            queue.removeChildListener((IQueueChildListener)this.queueListener);
        }
    }

    private final class RMListener
    implements IResourceManagerListener {
        private RMListener() {
        }

        public void handleEvent(IResourceManagerChangeEvent e) {
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
        }

        public void handleEvent(final IResourceManagerErrorEvent e) {
            ResourceManagerView.this.refreshViewer((IPElement)e.getSource());
            UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    Status status = new Status(4, "org.eclipse.ptp.ui", e.getMessage());
                    ErrorDialog.openError((Shell)PTPUIPlugin.getDisplay().getActiveShell(), (String)"Resource Manager Error", (String)("The \"" + e.getSource().getName() + "\" resource manager reported the following error"), (IStatus)status);
                }
            });
        }
    }
}

