/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpich2.core.rmsystem;

import java.util.Collection;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elementcontrols.IPQueueControl;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.rm.mpich2.core.rmsystem.MPICH2ResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpich2.core.rtsystem.MPICH2ProxyRuntimeClient;
import org.eclipse.ptp.rm.mpich2.core.rtsystem.MPICH2RuntimeSystem;
import org.eclipse.ptp.rmsystem.AbstractRuntimeResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPICH2ResourceManager
extends AbstractRuntimeResourceManager {
    private Integer MPICH2RMID;

    public MPICH2ResourceManager(Integer id, IPUniverseControl universe, IResourceManagerConfiguration config) {
        super(id.toString(), universe, config);
        this.MPICH2RMID = id;
    }

    protected void doAfterCloseConnection() {
    }

    protected void doAfterOpenConnection() {
    }

    protected void doBeforeCloseConnection() {
    }

    protected void doBeforeOpenConnection() {
    }

    protected IPJobControl doCreateJob(IPQueueControl queue, String jobId, AttributeManager attrs) {
        return this.newJob(queue, jobId, attrs);
    }

    protected IPMachineControl doCreateMachine(String machineId, AttributeManager attrs) {
        return this.newMachine(machineId, attrs);
    }

    protected IPNodeControl doCreateNode(IPMachineControl machine, String nodeId, AttributeManager attrs) {
        return this.newNode(machine, nodeId, attrs);
    }

    protected IPProcessControl doCreateProcess(IPJobControl job, String processId, AttributeManager attrs) {
        return this.newProcess(job, processId, attrs);
    }

    protected IPQueueControl doCreateQueue(String queueId, AttributeManager attrs) {
        return this.newQueue(queueId, attrs);
    }

    protected IRuntimeSystem doCreateRuntimeSystem() {
        MPICH2ResourceManagerConfiguration config = (MPICH2ResourceManagerConfiguration)this.getConfiguration();
        MPICH2ProxyRuntimeClient runtimeProxy = new MPICH2ProxyRuntimeClient(config, this.MPICH2RMID);
        return new MPICH2RuntimeSystem(runtimeProxy, this.getAttributeDefinitionManager());
    }

    protected boolean doUpdateJobs(IPQueueControl queue, Collection<IPJobControl> jobs, AttributeManager attrs) {
        return this.updateJobs(queue, jobs, attrs);
    }

    protected boolean doUpdateMachines(Collection<IPMachineControl> machines, AttributeManager attrs) {
        return this.updateMachines(machines, attrs);
    }

    protected boolean doUpdateNodes(IPMachineControl machine, Collection<IPNodeControl> nodes, AttributeManager attrs) {
        return this.updateNodes(machine, nodes, attrs);
    }

    protected boolean doUpdateProcesses(IPJobControl job, Collection<IPProcessControl> processes, AttributeManager attrs) {
        return this.updateProcesses(job, processes, attrs);
    }

    protected boolean doUpdateQueues(Collection<IPQueueControl> queues, AttributeManager attrs) {
        return this.updateQueues(queues, attrs);
    }
}

