/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.generichost.ui;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.remotetools.environment.generichost.core.ConfigFactory;
import org.eclipse.ptp.remotetools.environment.generichost.core.TargetControl;
import org.eclipse.ptp.remotetools.environment.generichost.ui.Messages;
import org.eclipse.ptp.remotetools.environment.wizard.AbstractEnvironmentDialogPage;
import org.eclipse.ptp.remotetools.utils.ui.swt.AuthenticationFrame;
import org.eclipse.ptp.remotetools.utils.ui.swt.AuthenticationFrameMold;
import org.eclipse.ptp.remotetools.utils.ui.swt.ComboGroup;
import org.eclipse.ptp.remotetools.utils.ui.swt.ComboGroupItem;
import org.eclipse.ptp.remotetools.utils.ui.swt.Frame;
import org.eclipse.ptp.remotetools.utils.ui.swt.TextGroup;
import org.eclipse.ptp.remotetools.utils.ui.swt.TextMold;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ConfigurationPage
extends AbstractEnvironmentDialogPage {
    ConfigFactory configFactory = null;
    private String targetName;
    private TextGroup targetNameGroup;
    private AuthenticationFrame remoteAuthFrame;
    private TextGroup systemWorkspaceGroup;
    private DataModifyListener dataModifyListener;

    public ConfigurationPage(String targetName, Map attributesMap) {
        super(targetName);
        this.targetName = targetName;
        this.configFactory = new ConfigFactory(attributesMap);
    }

    public ConfigurationPage() {
        super(Messages.ConfigurationPage_DefaultTargetName);
        this.targetName = Messages.ConfigurationPage_DefaultTargetName;
        this.configFactory = new ConfigFactory();
    }

    public void createControl(Composite parent) {
        this.setDescription(Messages.ConfigurationPage_DialogDescription);
        this.setTitle(Messages.ConfigurationPage_DialogTitle);
        this.setErrorMessage(null);
        GridLayout topLayout = new GridLayout();
        Composite topControl = new Composite(parent, 0);
        this.setControl((Control)topControl);
        topControl.setLayout((Layout)topLayout);
        TextMold mold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.ConfigurationPage_LabelTargetName);
        this.targetNameGroup = new TextGroup(topControl, mold);
        this.createAuthControl(topControl);
        Frame frame = new Frame(topControl, "Remote application launcher:");
        mold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.ConfigurationPage_LabelSystemWorkspace);
        this.systemWorkspaceGroup = new TextGroup(frame.getTopUserReservedComposite(), mold);
        this.fillControls();
        this.registerListeners();
    }

    private void registerListeners() {
        this.dataModifyListener = new DataModifyListener();
        this.targetNameGroup.addModifyListener((ModifyListener)this.dataModifyListener);
        this.remoteAuthFrame.addModifyListener((ModifyListener)this.dataModifyListener);
        this.systemWorkspaceGroup.addModifyListener((ModifyListener)this.dataModifyListener);
    }

    private void fillControls() {
        ControlAttributes attributes = this.configFactory.getAttributes();
        this.targetNameGroup.setString(this.targetName);
        this.remoteAuthFrame.setLocalhostSelected(attributes.getBoolean("org.eclipse.ptp.remotetools.environment.generichost..localhost-selection"));
        this.remoteAuthFrame.setHostPort(attributes.getInteger("org.eclipse.ptp.remotetools.environment.generichost..connection-port"));
        this.remoteAuthFrame.setHostAddress(attributes.getString("org.eclipse.ptp.remotetools.environment.generichost..connection-address"));
        this.remoteAuthFrame.setUserName(attributes.getString("org.eclipse.ptp.remotetools.environment.generichost..login-username"));
        this.remoteAuthFrame.setPassword(attributes.getString("org.eclipse.ptp.remotetools.environment.generichost..login-password"));
        this.remoteAuthFrame.setPublicKeyPath(attributes.getString("org.eclipse.ptp.remotetools.environment.generichost..key-path"));
        this.remoteAuthFrame.setPassphrase(attributes.getString("org.eclipse.ptp.remotetools.environment.generichost..key-passphrase"));
        this.remoteAuthFrame.setTimeout(attributes.getInteger("org.eclipse.ptp.remotetools.environment.generichost..connection-timeout"));
        this.remoteAuthFrame.setPasswordBased(attributes.getBoolean("org.eclipse.ptp.remotetools.environment.generichost..is-passwd-auth"));
        this.systemWorkspaceGroup.setString(attributes.getString("org.eclipse.ptp.remotetools.environment.generichost..system-workspace-dir"));
        Map cipherMap = TargetControl.getCipherTypesMap();
        Set cKeySet = cipherMap.keySet();
        ComboGroup cipherGroup = this.remoteAuthFrame.getCipherTypeGroup();
        for (String key : cKeySet) {
            String value = (String)cipherMap.get(key);
            cipherGroup.add(new ComboGroupItem(key, value));
        }
        cipherGroup.selectIndexUsingID(attributes.getString("org.eclipse.ptp.remotetools.environment.generichost..cipher-type"));
    }

    private void readControls() {
        ControlAttributes attributes = this.configFactory.getAttributes();
        this.targetName = this.targetNameGroup.getString();
        attributes.setBooleanAttribute("org.eclipse.ptp.remotetools.environment.generichost..localhost-selection", this.remoteAuthFrame.isLocalhostSelected());
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..login-username", this.remoteAuthFrame.getUserName());
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..login-password", this.remoteAuthFrame.getPassword());
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..connection-address", this.remoteAuthFrame.getHostAddress());
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..connection-port", Integer.toString(this.remoteAuthFrame.getHostPort()));
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..key-path", this.remoteAuthFrame.getPublicKeyPath());
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..key-passphrase", this.remoteAuthFrame.getPassphrase());
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..connection-timeout", Integer.toString(this.remoteAuthFrame.getTimeout()));
        attributes.setBooleanAttribute("org.eclipse.ptp.remotetools.environment.generichost..is-passwd-auth", this.remoteAuthFrame.isPasswordBased());
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..system-workspace-dir", this.systemWorkspaceGroup.getString());
        attributes.setStringAttribute("org.eclipse.ptp.remotetools.environment.generichost..cipher-type", this.remoteAuthFrame.getSelectedCipherType().getId());
    }

    private void createAuthControl(Composite topControl) {
        AuthenticationFrameMold amold = new AuthenticationFrameMold(Messages.ConfigurationPage_ConnectionFrameTitle);
        amold.setBitmask(2);
        amold.setLabelLocalhost(Messages.ConfigurationPage_LabelLocalhost);
        amold.setLabelRemoteHost(Messages.ConfigurationPage_LabelRemoteHost);
        amold.setLabelHideAdvancedOptions(Messages.ConfigurationPage_LabelHideAdvancedOptions);
        amold.setLabelHostAddress(Messages.ConfigurationPage_LabelHostAddress);
        amold.setLabelHostPort(Messages.ConfigurationPage_LabelHostPort);
        amold.setLabelIsPasswordBased(Messages.ConfigurationPage_LabelIsPasswordBased);
        amold.setLabelIsPublicKeyBased(Messages.ConfigurationPage_LabelIsPublicKeyBased);
        amold.setLabelPassphrase(Messages.ConfigurationPage_LabelPassphrase);
        amold.setLabelPassword(Messages.ConfigurationPage_LabelPassword);
        amold.setLabelPublicKeyPath(Messages.ConfigurationPage_LabelPublicKeyPath);
        amold.setLabelPublicKeyPathButton(Messages.ConfigurationPage_LabelPublicKeyPathButton);
        amold.setLabelPublicKeyPathTitle(Messages.ConfigurationPage_LabelPublicKeyPathTitle);
        amold.setLabelShowAdvancedOptions(Messages.ConfigurationPage_LabelShowAdvancedOptions);
        amold.setLabelTimeout(Messages.ConfigurationPage_LabelTimeout);
        amold.setLabelCipherType(Messages.ConfigurationPage_CipherType);
        amold.setLabelUserName(Messages.ConfigurationPage_LabelUserName);
        this.remoteAuthFrame = new AuthenticationFrame(topControl, amold);
    }

    public Map getAttributes() {
        return this.configFactory.getMap();
    }

    public boolean isValid() {
        try {
            this.remoteAuthFrame.validateFields();
            this.configFactory.createTargetConfig();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }

    public String getName() {
        return this.targetName;
    }

    class DataModifyListener
    implements ModifyListener {
        int counter = 0;

        DataModifyListener() {
        }

        public synchronized void enable() {
            ++this.counter;
        }

        public synchronized void disable() {
            --this.counter;
        }

        public synchronized void modifyText(ModifyEvent e) {
            if (this.counter < 0) {
                return;
            }
            ConfigurationPage.this.readControls();
            ConfigurationPage.this.getContainer().updateButtons();
        }
    }
}

