/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.perf.internal.PerformanceLaunchSteps;

public class PerformanceLaunchManager {
    private static final String buildText = "Instrumenting and Building";
    private static final String launchText = "Executing Instrumented Project";
    private static final String collectText = "Collecting Performance Data";
    private String appNameAttribute;
    private String projNameAttribute;
    private String appPathAttribute = null;
    private LaunchConfigurationDelegate paraDel;

    public PerformanceLaunchManager(LaunchConfigurationDelegate delegate, String appNameAtt, String projNameAtt) {
        this.paraDel = delegate;
        this.appNameAttribute = appNameAtt;
        this.projNameAttribute = projNameAtt;
    }

    public PerformanceLaunchManager(LaunchConfigurationDelegate delegate, String appNameAtt, String projNameAtt, String appPathAtt) {
        this.paraDel = delegate;
        this.appNameAttribute = appNameAtt;
        this.appPathAttribute = appPathAtt;
        this.projNameAttribute = projNameAtt;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        final ILaunch launch = launchIn;
        final PerformanceLaunchSteps tauManager = new PerformanceLaunchSteps(configuration, this.appNameAttribute, this.projNameAttribute, this.appPathAttribute);
        Job tauBuild = new Job(buildText){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    tauManager.buildIndstrumented(monitor);
                }
                catch (Exception e) {
                    return new Status(4, "com.ibm.jdg2e.concurrency", 4, "Build Incomplete", (Throwable)e);
                }
                return new Status(0, "com.ibm.jdg2e.concurrency", 0, "Build Successful", null);
            }
        };
        final Job tauRun = new Job(launchText){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (!tauManager.performLaunch(PerformanceLaunchManager.this.paraDel, launch, monitor)) {
                        return new Status(2, "com.ibm.jdg2e.concurrency", 2, "Nothing to run", null);
                    }
                }
                catch (Exception e) {
                    try {
                        tauManager.cleanup();
                    }
                    catch (CoreException coreException) {}
                    return new Status(4, "com.ibm.jdg2e.concurrency", 4, "Execution Error", (Throwable)e);
                }
                return new Status(0, "com.ibm.jdg2e.concurrency", 0, "Execution Complete", null);
            }
        };
        final Job tauCollect = new Job(collectText){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    tauManager.postlaunch(monitor);
                }
                catch (Exception e) {
                    return new Status(4, "com.ibm.jdg2e.concurrency", 4, "Data Collection Error", (Throwable)e);
                }
                return new Status(0, "com.ibm.jdg2e.concurrency", 0, "Data Collected", null);
            }
        };
        JobChangeAdapter tauChange = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob().getName().equals(PerformanceLaunchManager.buildText) && event.getResult().isOK()) {
                    tauRun.schedule();
                } else if (event.getJob().getName().equals(PerformanceLaunchManager.launchText) && event.getResult().isOK()) {
                    tauCollect.schedule();
                }
            }
        };
        tauBuild.addJobChangeListener((IJobChangeListener)tauChange);
        tauRun.addJobChangeListener((IJobChangeListener)tauChange);
        tauBuild.schedule();
    }
}

