/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.PAST;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerCallbackManager;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerProblemFactory;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ptp.pldt.common.util.Utility;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPError;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPErrorManager;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTPragma;
import org.eclipse.ptp.pldt.openmp.analysis.dictionary.Dictionary;
import org.eclipse.ptp.pldt.openmp.analysis.dictionary.Symbol;
import org.eclipse.ptp.pldt.openmp.analysis.parser.OpenMPScanner;
import org.eclipse.ptp.pldt.openmp.analysis.parser.OpenMPToken;

public class PASTOMPFactory {
    protected PASTPragma pragma_ = null;
    protected PASTOMPPragma ompPragma_ = null;
    protected IASTTranslationUnit ast_ = null;
    protected Dictionary dictionary_ = null;
    protected static boolean traceOn_ = false;
    private static final boolean traceOn = false;
    protected OpenMPScanner scanner_ = null;
    protected OpenMPToken token_ = null;
    protected ScannerCallbackManager callbackManager_ = null;
    protected static final ScannerProblemFactory spf = new ScannerProblemFactory();
    protected static char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final int STRUCTURED_BLOCK = 0;
    public static final int FOR_BLOCK = 1;
    public static final int EXPRESSION_BLOCK = 2;
    public static final int LOCATION_ONLY = 3;

    protected PASTOMPFactory(PASTPragma pragma, IASTTranslationUnit ast, Dictionary dictionary) {
        this.pragma_ = pragma;
        this.scanner_ = new OpenMPScanner(this.pragma_.getContent());
        this.ast_ = ast;
        this.dictionary_ = dictionary;
        if (traceOn_) {
            this.readTokens();
        }
        this.otherinit(null);
    }

    private void experiment() {
        IDocument document;
        IASTFileLocation loc = this.pragma_.getFileLocation();
        if (loc != null && (document = Utility.getDocument((String)loc.getFileName())) != null) {
            try {
                String txt = document.get(this.pragma_.getLocalOffset(), this.pragma_.getLength());
                System.out.println(txt);
            }
            catch (Exception exception) {}
        }
    }

    protected PASTPragma retrievePragma() {
        return this.ompPragma_ != null ? this.ompPragma_ : this.pragma_;
    }

    public static PASTPragma makePASTOMP(PASTPragma pragma, IASTTranslationUnit ast, Dictionary dictionary) {
        PASTOMPFactory factory = new PASTOMPFactory(pragma, ast, dictionary);
        factory.parse();
        factory.locateRegion();
        return factory.retrievePragma();
    }

    protected boolean parse() {
        OpenMPToken tok = this.nextToken();
        if (tok == null) {
            return false;
        }
        if (tok.getType() != 26) {
            return false;
        }
        tok = this.nextToken();
        if (tok.getType() != 27) {
            return false;
        }
        if (this.nextToken().getType() != 15) {
            return false;
        }
        this.ompPragma_ = new PASTOMPPragma(this.pragma_);
        this.nextToken();
        OpenMPToken typeToken = this.token_;
        if (this.token_ == null) {
            return false;
        }
        this.ompPragma_.setOMPType(this.setOMPType(this.token_.getType()));
        if (this.token_ == null) {
            return false;
        }
        switch (this.ompPragma_.getOMPType()) {
            case 0: {
                this.completeParallel();
                break;
            }
            case 1: {
                this.completeFor();
                break;
            }
            case 5: {
                this.completeParallelFor();
                break;
            }
            case 3: {
                this.completeSections();
                break;
            }
            case 6: {
                this.completeParallelSections();
                break;
            }
            case 4: {
                this.completeSingle();
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                break;
            }
            case 11: {
                this.completeFlush();
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                this.completeThreadPrivate();
                break;
            }
            case -1: {
                String typeString = typeToken != null ? typeToken.getImage() : "";
                this.handleProblem("Unexpected token '" + typeString + "'", 2);
            }
        }
        while (this.token_ != null) {
            this.handleProblem("Unexpected token '" + this.token_.getImage() + "'", 2);
            this.nextToken();
        }
        return true;
    }

    protected int setOMPType(int t) {
        this.nextToken();
        switch (t) {
            case 17: {
                if (this.token_ == null) {
                    return 0;
                }
                if (this.token_.getType() == 8) {
                    this.nextToken();
                    return 5;
                }
                if (this.token_.getType() == 22) {
                    this.nextToken();
                    return 6;
                }
                return 0;
            }
            case 8: {
                return 1;
            }
            case 22: {
                return 3;
            }
            case 21: {
                return 2;
            }
            case 24: {
                return 4;
            }
            case 11: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 1: {
                return 9;
            }
            case 0: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 16: {
                return 12;
            }
            case 25: {
                return 13;
            }
        }
        return -1;
    }

    protected OpenMPToken[] getIdentifierList() {
        LinkedList<OpenMPToken> l = new LinkedList<OpenMPToken>();
        if (this.token_ == null) {
            return null;
        }
        boolean commaNext = false;
        this.nextToken();
        while (this.token_ != null) {
            if (commaNext) {
                if (this.token_.getType() != 6) break;
                commaNext = false;
                this.nextToken();
                continue;
            }
            l.add(this.token_);
            commaNext = true;
            this.nextToken();
        }
        OpenMPToken[] ompl = new OpenMPToken[l.size()];
        int count = 0;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            ompl[count++] = (OpenMPToken)i.next();
            Symbol[] symbols = this.dictionary_.getSymbolsFor(ompl[count - 1].getImage());
            if (symbols.length == 0) {
                this.handleProblem("Undefined symbol '" + ompl[count - 1].getImage() + "'", 2);
                continue;
            }
            boolean found = false;
            int j = 0;
            while (j < symbols.length) {
                IASTNode fctn = symbols[j].getDefiningFunction();
                if (fctn != null && fctn instanceof IASTFunctionDefinition && this.isSymbolRelevant(symbols[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) continue;
            this.handleProblem("Symbol out of scope: '" + ompl[count - 1].getImage() + "'", 2);
        }
        this.nextToken();
        return ompl;
    }

    protected boolean isSymbolRelevant(Symbol symbol) {
        boolean tf;
        IASTNode node = null;
        try {
            IScope scope = symbol.getScope();
            node = ASTInternal.getPhysicalNodeOfScope((IScope)scope);
        }
        catch (Exception exception) {
            return false;
        }
        Utility.Location l = Utility.getLocation((IASTNode)node);
        int nodeOffset = l != null ? l.getLow() : 0;
        int nodeEndset = l != null ? l.getHigh() : 0;
        int pOffset = this.pragma_.getLocalOffset();
        int pEndset = pOffset + this.pragma_.getLength() - 1;
        boolean bl = tf = nodeEndset >= pOffset && pEndset >= nodeOffset;
        if (!tf) {
            return tf;
        }
        Utility.Location dl = Utility.getLocation((IASTNode)symbol.getDeclarator());
        if (dl == null) {
            return false;
        }
        return dl.getLow() <= pOffset;
    }

    protected OpenMPToken nextToken() {
        if (this.token_ != null && this.token_.getNext() != null) {
            this.token_ = this.token_.getNext();
            return this.token_;
        }
        OpenMPToken token = this.scanner_.nextToken();
        if (this.token_ != null) {
            this.token_.setNext(token);
        }
        this.token_ = token;
        return this.token_;
    }

    protected OpenMPToken mark() {
        if (this.token_ == null) {
            this.token_ = this.nextToken();
        }
        return this.token_;
    }

    protected void backupTo(OpenMPToken token) {
        this.token_ = token;
    }

    private void readTokens() {
        OpenMPScanner scanner = new OpenMPScanner(this.pragma_.getContent());
        OpenMPToken token = null;
        do {
            if ((token = scanner.nextToken()) == null) continue;
            System.out.println("Token:" + token.getImage() + " type=" + token.getType());
        } while (token != null);
    }

    private void completeParallel() {
        boolean bShared = false;
        boolean bPrivate = false;
        boolean bFirstPrivate = false;
        boolean bDefault = false;
        boolean bReduction = false;
        boolean bCopyin = false;
        boolean bIf = false;
        boolean bNumthreads = false;
        block10: while (this.token_ != null) {
            switch (this.token_.getType()) {
                case 23: {
                    if (bShared) continue block10;
                    bShared = this.setShared();
                    break;
                }
                case 18: {
                    if (bPrivate) continue block10;
                    bPrivate = this.setPrivate();
                    break;
                }
                case 6: {
                    if (bFirstPrivate) continue block10;
                    bFirstPrivate = this.setFirstPrivate();
                    break;
                }
                case 5: {
                    if (bDefault) continue block10;
                    bDefault = this.setDefault();
                    break;
                }
                case 19: {
                    if (bReduction) continue block10;
                    bReduction = this.setReduction();
                    break;
                }
                case 2: {
                    if (bCopyin) continue block10;
                    bCopyin = this.setCopyin();
                    break;
                }
                case 9: {
                    if (bIf) continue block10;
                    bIf = this.setIf();
                    break;
                }
                case 14: {
                    if (bNumthreads) continue block10;
                    bNumthreads = this.setNumThreads();
                    break;
                }
                default: {
                    this.handleProblem("Unexpected token " + this.token_.getImage(), 2);
                    this.nextToken();
                }
            }
        }
    }

    private void completeFor() {
        boolean bPrivate = false;
        boolean bFirstPrivate = false;
        boolean bLastPrivate = false;
        boolean bReduction = false;
        boolean bOrdered = false;
        boolean bSchedule = false;
        boolean bNowait = false;
        block9: while (this.token_ != null) {
            switch (this.token_.getType()) {
                case 18: {
                    if (bPrivate) continue block9;
                    bPrivate = this.setPrivate();
                    break;
                }
                case 6: {
                    if (bFirstPrivate) continue block9;
                    bFirstPrivate = this.setFirstPrivate();
                    break;
                }
                case 10: {
                    if (bLastPrivate) continue block9;
                    bLastPrivate = this.setLastPrivate();
                    break;
                }
                case 19: {
                    if (bReduction) continue block9;
                    bReduction = this.setReduction();
                    break;
                }
                case 16: {
                    if (!bOrdered) {
                        this.ompPragma_.setOrdered(true);
                        bOrdered = true;
                    }
                    this.nextToken();
                    break;
                }
                case 20: {
                    if (bSchedule) continue block9;
                    bSchedule = this.setSchedule();
                    break;
                }
                case 13: {
                    if (!bNowait) {
                        this.ompPragma_.setNoWait(true);
                        bNowait = true;
                    }
                    this.nextToken();
                    break;
                }
                default: {
                    this.handleProblem("Unexpected token " + this.token_.getImage(), 2);
                    this.nextToken();
                }
            }
        }
    }

    private void completeParallelFor() {
        boolean bShared = false;
        boolean bPrivate = false;
        boolean bFirstPrivate = false;
        boolean bLastPrivate = false;
        boolean bDefault = false;
        boolean bReduction = false;
        boolean bCopyin = false;
        boolean bIf = false;
        boolean bOrdered = false;
        boolean bSchedule = false;
        block12: while (this.token_ != null) {
            switch (this.token_.getType()) {
                case 23: {
                    if (bShared) continue block12;
                    bShared = this.setShared();
                    break;
                }
                case 18: {
                    if (bPrivate) continue block12;
                    bPrivate = this.setPrivate();
                    break;
                }
                case 6: {
                    if (bFirstPrivate) continue block12;
                    bFirstPrivate = this.setFirstPrivate();
                    break;
                }
                case 10: {
                    if (bLastPrivate) continue block12;
                    bLastPrivate = this.setLastPrivate();
                    break;
                }
                case 5: {
                    if (bDefault) continue block12;
                    bDefault = this.setDefault();
                    break;
                }
                case 19: {
                    if (bReduction) continue block12;
                    bReduction = this.setReduction();
                    break;
                }
                case 2: {
                    if (bCopyin) continue block12;
                    bCopyin = this.setCopyin();
                    break;
                }
                case 9: {
                    if (bIf) continue block12;
                    bIf = this.setIf();
                    break;
                }
                case 16: {
                    if (!bOrdered) {
                        this.ompPragma_.setOrdered(true);
                        bOrdered = true;
                    }
                    this.nextToken();
                    break;
                }
                case 20: {
                    if (bSchedule) continue block12;
                    bSchedule = this.setSchedule();
                    break;
                }
                default: {
                    this.handleProblem("Unexpected token " + this.token_.getImage(), 2);
                    this.nextToken();
                }
            }
        }
    }

    private void completeParallelSections() {
        boolean bShared = false;
        boolean bPrivate = false;
        boolean bFirstPrivate = false;
        boolean bLastPrivate = false;
        boolean bDefault = false;
        boolean bReduction = false;
        boolean bCopyin = false;
        boolean bIf = false;
        block10: while (this.token_ != null) {
            switch (this.token_.getType()) {
                case 23: {
                    if (bShared) continue block10;
                    bShared = this.setShared();
                    break;
                }
                case 18: {
                    if (bPrivate) continue block10;
                    bPrivate = this.setPrivate();
                    break;
                }
                case 6: {
                    if (bFirstPrivate) continue block10;
                    bFirstPrivate = this.setFirstPrivate();
                    break;
                }
                case 10: {
                    if (bLastPrivate) continue block10;
                    bLastPrivate = this.setLastPrivate();
                    break;
                }
                case 5: {
                    if (bDefault) continue block10;
                    bDefault = this.setDefault();
                    break;
                }
                case 19: {
                    if (bReduction) continue block10;
                    bReduction = this.setReduction();
                    break;
                }
                case 2: {
                    if (bCopyin) continue block10;
                    bCopyin = this.setCopyin();
                    break;
                }
                case 9: {
                    if (bIf) continue block10;
                    bIf = this.setIf();
                    break;
                }
                default: {
                    this.handleProblem("Unexpected token " + this.token_.getImage(), 2);
                    this.nextToken();
                }
            }
        }
    }

    private void completeSections() {
        boolean bPrivate = false;
        boolean bFirstPrivate = false;
        boolean bLastPrivate = false;
        boolean bReduction = false;
        boolean bNowait = false;
        block7: while (this.token_ != null) {
            switch (this.token_.getType()) {
                case 18: {
                    if (bPrivate) continue block7;
                    bPrivate = this.setPrivate();
                    break;
                }
                case 6: {
                    if (bFirstPrivate) continue block7;
                    bFirstPrivate = this.setFirstPrivate();
                    break;
                }
                case 10: {
                    if (bLastPrivate) continue block7;
                    bLastPrivate = this.setLastPrivate();
                    break;
                }
                case 19: {
                    if (bReduction) continue block7;
                    bReduction = this.setReduction();
                    break;
                }
                case 13: {
                    if (!bNowait) {
                        this.ompPragma_.setNoWait(true);
                        bNowait = true;
                    }
                    this.nextToken();
                    break;
                }
                default: {
                    this.handleProblem("Unexpected token " + this.token_.getImage(), 2);
                    this.nextToken();
                }
            }
        }
    }

    private void completeSingle() {
        boolean bPrivate = false;
        boolean bFirstPrivate = false;
        boolean bCopyPrivate = false;
        boolean bNowait = false;
        block6: while (this.token_ != null) {
            switch (this.token_.getType()) {
                case 18: {
                    if (bPrivate) continue block6;
                    bPrivate = this.setPrivate();
                    break;
                }
                case 6: {
                    if (bFirstPrivate) continue block6;
                    bFirstPrivate = this.setFirstPrivate();
                    break;
                }
                case 3: {
                    if (bCopyPrivate) continue block6;
                    bCopyPrivate = this.setCopyPrivate();
                    break;
                }
                case 13: {
                    if (!bNowait) {
                        this.ompPragma_.setNoWait(true);
                        bNowait = true;
                    }
                    this.nextToken();
                    break;
                }
                default: {
                    this.handleProblem("Unexpected token " + this.token_.getImage(), 2);
                    this.nextToken();
                }
            }
        }
    }

    private void completeFlush() {
        if (this.token_ == null || this.token_.getType() != 8) {
            return;
        }
        OpenMPToken[] list = this.getIdentifierList();
        this.ompPragma_.setPrivateList(list);
    }

    private void completeThreadPrivate() {
        if (this.token_ == null || this.token_.getType() != 8) {
            return;
        }
        OpenMPToken[] list = this.getIdentifierList();
        this.ompPragma_.setThreadPrivateList(list);
    }

    private int getReductionOperator() {
        switch (this.token_.getType()) {
            case 16: {
                return 0;
            }
            case 23: {
                return 1;
            }
            case 21: {
                return 2;
            }
            case 30: {
                return 3;
            }
            case 27: {
                return 4;
            }
            case 33: {
                return 5;
            }
            case 29: {
                return 6;
            }
            case 32: {
                return 7;
            }
        }
        return -1;
    }

    private int getScheduleKind() {
        switch (this.token_.getType()) {
            case 31: {
                return 0;
            }
            case 28: {
                return 1;
            }
            case 29: {
                return 2;
            }
            case 30: {
                return 3;
            }
        }
        return -1;
    }

    private OpenMPToken[] getExpression() {
        LinkedList<OpenMPToken> l = new LinkedList<OpenMPToken>();
        int parenCt = 1;
        this.nextToken();
        while (this.token_ != null) {
            if (this.token_.getType() == 9) {
                if (--parenCt == 0) break;
                l.add(this.token_);
            } else if (this.token_.getType() == 6) {
                if (parenCt == 1) break;
                l.add(this.token_);
            } else if (this.token_.getType() == 8) {
                ++parenCt;
                l.add(this.token_);
            } else {
                l.add(this.token_);
            }
            this.nextToken();
        }
        OpenMPToken[] list = new OpenMPToken[l.size()];
        int i = 0;
        while (i < l.size()) {
            list[i] = (OpenMPToken)l.get(i);
            ++i;
        }
        this.nextToken();
        return list;
    }

    private boolean setIf() {
        this.nextToken();
        OpenMPToken[] list = this.getExpression();
        this.ompPragma_.setIfExpression(list);
        return true;
    }

    private boolean setPrivate() {
        this.nextToken();
        OpenMPToken[] list = this.getIdentifierList();
        this.ompPragma_.setPrivateList(list);
        return true;
    }

    private boolean setFirstPrivate() {
        this.nextToken();
        OpenMPToken[] list = this.getIdentifierList();
        this.ompPragma_.setFirstPrivateList(list);
        return true;
    }

    private boolean setLastPrivate() {
        this.nextToken();
        OpenMPToken[] list = this.getIdentifierList();
        this.ompPragma_.setLastPrivateList(list);
        return true;
    }

    private boolean setShared() {
        this.nextToken();
        OpenMPToken[] list = this.getIdentifierList();
        this.ompPragma_.setSharedList(list);
        return true;
    }

    private boolean setCopyin() {
        this.nextToken();
        OpenMPToken[] list = this.getIdentifierList();
        this.ompPragma_.setCopyinList(list);
        return true;
    }

    private boolean setCopyPrivate() {
        this.nextToken();
        OpenMPToken[] list = this.getIdentifierList();
        this.ompPragma_.setCopyPrivateList(list);
        return true;
    }

    private boolean setDefault() {
        boolean shared = false;
        this.nextToken();
        if (this.token_.getType() == 8) {
            this.nextToken();
            if (this.token_.getType() == 23) {
                shared = true;
            } else if (this.token_.getType() == 12) {
                shared = false;
            } else {
                return false;
            }
            this.nextToken();
            if (this.token_ == null || this.token_.getType() != 9) {
                return false;
            }
            this.ompPragma_.setDefault(shared ? 0 : 1);
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean setReduction() {
        this.nextToken();
        if (this.token_.getType() == 8) {
            this.nextToken();
            int ro = this.getReductionOperator();
            this.nextToken();
            if (this.token_ != null && this.token_.getType() == 4) {
                OpenMPToken[] rlist = this.getIdentifierList();
                this.ompPragma_.setReductionOperator(ro);
                this.ompPragma_.setReductionList(rlist);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean setNumThreads() {
        this.nextToken();
        if (this.token_.getType() == 8) {
            OpenMPToken[] expr = this.getExpression();
            if (this.token_ == null || this.token_.getType() != 9) {
                return false;
            }
            this.ompPragma_.setNumThreadsExpr(expr);
            return true;
        }
        return false;
    }

    private boolean setSchedule() {
        this.nextToken();
        if (this.token_.getType() == 8) {
            this.nextToken();
            int kind = this.getScheduleKind();
            this.nextToken();
            if (this.token_ != null && this.token_.getType() == 6) {
                OpenMPToken[] expr = this.getExpression();
                this.ompPragma_.setScheduleKind(kind);
                this.ompPragma_.setChunkExpression(expr);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void otherinit(ISourceElementRequestor requestor) {
    }

    protected void handleProblem(String description, int severity) {
        OpenMPError error = new OpenMPError(description, this.pragma_.getContainingFilename(), this.pragma_.getStartingLine(), severity);
        OpenMPErrorManager.getCurrentErrorManager().addError(error);
        this.ompPragma_.addProblem(error);
    }

    private void locateRegion() {
        if (this.ompPragma_ == null) {
            return;
        }
        switch (this.ompPragma_.getOMPType()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                this.determineRegion(0, this.ompPragma_);
                break;
            }
            case 1: 
            case 5: {
                this.determineRegion(1, this.ompPragma_);
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                this.determineRegion(3, this.ompPragma_);
                break;
            }
            case 10: {
                this.determineRegion(2, this.ompPragma_);
                break;
            }
        }
    }

    protected void determineRegion(int type, PASTOMPPragma ompPragma) {
        IASTNode region;
        RegionDeterminationVisitor rdv = new RegionDeterminationVisitor(type, ompPragma);
        this.ast_.accept((ASTVisitor)rdv);
        if (type == 0) {
            IASTNode region2 = ompPragma.getRegion();
            if (region2 == null || !(region2 instanceof IASTCompoundStatement)) {
                this.handleProblem("Pragma expects structured block to follow it", 2);
            }
        } else if (!(type != 1 || (region = ompPragma.getRegion()) != null && region instanceof IASTForStatement)) {
            this.handleProblem("Pragma expects for loop to follow it", 2);
        }
    }

    protected class RegionDeterminationVisitor
    extends ASTVisitor {
        protected int searchType_ = 0;
        protected PASTOMPPragma oPragma_ = null;
        protected int pragmaLine_ = 0;
        protected int pragmaLocation_ = 0;
        protected int pragmaLength_ = 0;
        protected int closeness_ = -1;
        public static final int STRUCTURED_BLOCK = 0;
        public static final int FOR_BLOCK = 1;
        public static final int EXPRESSION_BLOCK = 2;
        public static final int LOCATION_ONLY = 3;

        public RegionDeterminationVisitor(int type, PASTOMPPragma ompPragma) {
            this.searchType_ = type;
            switch (this.searchType_) {
                case 0: {
                    this.shouldVisitStatements = true;
                    break;
                }
                case 1: {
                    this.shouldVisitStatements = true;
                    break;
                }
                case 2: {
                    this.shouldVisitStatements = true;
                    break;
                }
                case 3: {
                    this.shouldVisitStatements = true;
                }
            }
            this.oPragma_ = ompPragma;
            this.pragmaLine_ = this.oPragma_.getStartingLine();
            this.pragmaLocation_ = this.oPragma_.getOffset();
            this.pragmaLength_ = this.oPragma_.getLength();
        }

        public int visit(IASTStatement statement) {
            ASTNode node;
            ASTNode aSTNode = node = statement instanceof ASTNode ? (ASTNode)statement : null;
            if (node == null) {
                return 3;
            }
            if (node.getContainingFilename().equals(this.oPragma_.getFileLocation().getFileName())) {
                int totalOffset = node.getOffset();
                Utility.Location loc = Utility.getLocation((IASTNode)node);
                assert (loc != null);
                int localOffset = loc.getLow();
                int length = loc.getHigh() - loc.getLow() + 1;
                if (totalOffset < this.pragmaLocation_) {
                    if (this.pragmaLocation_ + this.pragmaLength_ < totalOffset + length) {
                        this.oPragma_.setLocation(statement, 1);
                    } else if (totalOffset + length < this.pragmaLocation_) {
                        int closeness = this.pragmaLocation_ - (totalOffset + length);
                        if (this.closeness_ == -1 || closeness < this.closeness_) {
                            this.oPragma_.setLocation(statement, 0);
                            this.closeness_ = closeness;
                        }
                    }
                }
                if (totalOffset > this.pragmaLocation_) {
                    if (this.searchType_ != 3) {
                        if (this.searchType_ == 1 && !(statement instanceof IASTForStatement)) {
                            return 2;
                        }
                        this.oPragma_.setRegionFilename(node.getContainingFilename());
                        this.oPragma_.setRegionLength(length);
                        this.oPragma_.setRegionOffset(localOffset);
                        this.oPragma_.setRegion((IASTNode)statement);
                        if (traceOn_) {
                            System.out.println(String.valueOf(this.searchType_ == 1 ? "(for)" : "(region)") + "pragma at " + this.pragmaLocation_ + " has statement at " + localOffset);
                        }
                    }
                    return 2;
                }
            }
            return 3;
        }
    }
}

