/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpich2.ui.rmLaunchConfiguration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.IntegerAttributeDefinition;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPICH2RMLaunchConfigurationDynamicTab
extends AbstractRMLaunchConfigurationDynamicTab {
    private static final String NUMBER_OF_PROCESSES_LABEL = "Number of Processes: ";
    private static final String ATTR_PREFIX = "org.eclipse.ptp.rm.mpich2.ui.launchAttributes";
    private static final String ATTR_NUMPROCS = "org.eclipse.ptp.rm.mpich2.ui.launchAttributes.numProcs";
    private static final RMLaunchValidation success = new RMLaunchValidation(true, "");
    private Text numProcsText;
    private String numProcsString = "0";
    private Composite control;

    public MPICH2RMLaunchConfigurationDynamicTab(IResourceManager rm) {
    }

    public RMLaunchValidation canSave(Control control, IResourceManager rm, IPQueue queue) {
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            new IntegerAttribute(numProcsAttrDef, this.numProcsString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, NUMBER_OF_PROCESSES_LABEL + e.getMessage());
        }
        return new RMLaunchValidation(true, "");
    }

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite(this.control, 0);
        GridLayout launchConfigLayout = new GridLayout(2, true);
        launchConfigLayout.marginHeight = 0;
        launchConfigLayout.marginWidth = 0;
        launchConfigLayout.numColumns = 2;
        comp.setLayout((Layout)launchConfigLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(NUMBER_OF_PROCESSES_LABEL);
        gd = new GridData(4, 4, true, false, 1, 1);
        gd.minimumWidth = label.computeSize((int)-1, (int)-1).x;
        label.setLayoutData((Object)gd);
        this.numProcsText = new Text(comp, 0);
        this.numProcsText.setTextLimit(10);
        gd = new GridData(4, 4, true, false, 1, 1);
        this.numProcsText.setText("1000");
        gd.minimumWidth = this.numProcsText.computeSize((int)-1, (int)-1).x;
        this.numProcsText.setLayoutData((Object)gd);
        this.numProcsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MPICH2RMLaunchConfigurationDynamicTab.this.numProcsString = MPICH2RMLaunchConfigurationDynamicTab.this.numProcsText.getText();
                MPICH2RMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
    }

    public IAttribute<?, ?, ?>[] getAttributes(IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) throws CoreException {
        int numProcs = configuration.getAttribute(ATTR_NUMPROCS, -1);
        IntegerAttribute iattr = null;
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            iattr = new IntegerAttribute(numProcsAttrDef, Integer.valueOf(numProcs));
        }
        catch (IllegalValueException illegalValueException) {
            return new IAttribute[0];
        }
        return new IAttribute[]{iattr};
    }

    public Control getControl() {
        return this.control;
    }

    public RMLaunchValidation initializeFrom(Control control, IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) {
        int numProcs;
        try {
            numProcs = configuration.getAttribute(ATTR_NUMPROCS, 1);
        }
        catch (CoreException e) {
            try {
                IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
                this.numProcsText.setText(numProcsAttrDef.create().getValueAsString());
            }
            catch (IllegalValueException e1) {
                return new RMLaunchValidation(false, NUMBER_OF_PROCESSES_LABEL + e.getMessage() + " : " + e1.getMessage());
            }
            return new RMLaunchValidation(false, NUMBER_OF_PROCESSES_LABEL + e.getMessage());
        }
        this.numProcsText.setText(Integer.toString(numProcs));
        return success;
    }

    public RMLaunchValidation isValid(ILaunchConfiguration configuration, IResourceManager rm, IPQueue queue) {
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            new IntegerAttribute(numProcsAttrDef, this.numProcsString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, NUMBER_OF_PROCESSES_LABEL + e.getMessage());
        }
        return new RMLaunchValidation(true, "");
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        IntegerAttribute iattr = null;
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            iattr = new IntegerAttribute(numProcsAttrDef, this.numProcsString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, NUMBER_OF_PROCESSES_LABEL + e.getMessage());
        }
        configuration.setAttribute(ATTR_NUMPROCS, iattr.getValue().intValue());
        return new RMLaunchValidation(true, "");
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            configuration.setAttribute(ATTR_NUMPROCS, numProcsAttrDef.create().getValue().intValue());
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, NUMBER_OF_PROCESSES_LABEL + e.getMessage());
        }
        return success;
    }

    private IntegerAttributeDefinition getNumProcsAttrDef(IResourceManager rm, IPQueue queue) {
        return JobAttributes.getNumberOfProcessesAttributeDefinition();
    }
}

