/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.ui.LaunchImages;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.ptp.launch.ui.LaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationFactory;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ResourcesTab
extends LaunchConfigurationTab {
    private Combo resourceManagerCombo = null;
    private IResourceManager resourceManager = null;
    private final Map<Integer, IResourceManager> resourceManagers = new HashMap<Integer, IResourceManager>();
    private final HashMap<IResourceManager, Integer> resourceManagerIndices = new HashMap();
    private ScrolledComposite launchAttrsScrollComposite;
    private final Map<IResourceManager, IRMLaunchConfigurationDynamicTab> rmDynamicTabs = new HashMap<IResourceManager, IRMLaunchConfigurationDynamicTab>();
    private final ContentsChangedListener launchContentsChangedListener = new ContentsChangedListener();

    public boolean canSave() {
        this.setErrorMessage(null);
        if (this.resourceManager == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.No_Resource_Manager"));
            return false;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(this.resourceManager);
        ScrolledComposite launchComp = this.getLaunchAttrsScrollComposite();
        if (rmDynamicTab == null || launchComp == null) {
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Control", this.resourceManager.getName()));
            return false;
        }
        RMLaunchValidation validation = rmDynamicTab.canSave((Control)launchComp, this.resourceManager, null);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        IModelManager modelManager = PTPCorePlugin.getDefault().getModelManager();
        IPUniverse universe = modelManager.getUniverse();
        IResourceManager[] rms = modelManager.getStartedResourceManagers(universe);
        new Label(comp, 0).setText(LaunchMessages.getResourceString("ApplicationTab.RM_Selection_Label"));
        this.resourceManagerCombo = new Combo(comp, 8);
        gd = new GridData(768);
        this.resourceManagerCombo.setLayoutData((Object)gd);
        int i = 0;
        while (i < rms.length) {
            this.resourceManagerCombo.add(rms[i].getName());
            this.resourceManagers.put(i, rms[i]);
            this.resourceManagerIndices.put(rms[i], i);
            ++i;
        }
        this.resourceManagerCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ResourcesTab.this.resourceManagerCombo) {
                    ResourcesTab.this.rmSelectionChanged();
                    ResourcesTab.this.updateLaunchAttributeControls(ResourcesTab.this.resourceManager, null, ResourcesTab.this.getLaunchConfiguration());
                    ResourcesTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.resourceManagerCombo.deselectAll();
        this.createVerticalSpacer(comp, 2);
        Group attrGroup = new Group(comp, 0);
        attrGroup.setText(LaunchMessages.getResourceString("ResourcesTab.Launch_Attributes"));
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        attrGroup.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        attrGroup.setLayout((Layout)gridLayout);
        ScrolledComposite scrollComp = this.createLaunchAttributeControlComposite((Composite)attrGroup, 2);
        this.setLaunchAttrsScrollComposite(scrollComp);
    }

    public Image getImage() {
        return LaunchImages.getImage("org.eclipse.ptp.launch.parallel_tab.gif");
    }

    public String getName() {
        return LaunchMessages.getResourceString("ResourcesTab.Resources");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.resourceManager = this.getResourceManager(configuration);
        if (this.resourceManager == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("ApplicationTab.No_Resource_Manager_Available"));
            return;
        }
        this.setResourceManagerComboSelection(this.resourceManager);
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(this.resourceManager);
        ScrolledComposite launchComp = this.getLaunchAttrsScrollComposite();
        if (rmDynamicTab == null || launchComp == null) {
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Configuration", this.resourceManager.getName()));
            return;
        }
        this.updateLaunchAttributeControls(this.resourceManager, null, this.getLaunchConfiguration());
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.resourceManager == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.No_Resource_Manager"));
            return false;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(this.resourceManager);
        if (rmDynamicTab == null) {
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Configuration", this.resourceManager.getName()));
            return false;
        }
        RMLaunchValidation validation = rmDynamicTab.isValid(configuration, this.resourceManager, null);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.resourceManager != null) {
            configuration.setAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", this.resourceManager.getUniqueName());
            IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(this.resourceManager);
            if (rmDynamicTab == null) {
                this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Configuration", this.resourceManager.getName()));
                return;
            }
            RMLaunchValidation validation = rmDynamicTab.performApply(configuration, this.resourceManager, null);
            if (!validation.isSuccess()) {
                this.setErrorMessage(validation.getMessage());
                return;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IResourceManager rm = this.getResourceManagerDefault();
        if (rm == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.No_Resource_Manager"));
            return;
        }
        String rmName = rm.getUniqueName();
        configuration.setAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", rmName);
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
        if (rmDynamicTab == null) {
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Configuration", rm.getName()));
        } else {
            rmDynamicTab.setDefaults(configuration, rm, null);
        }
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    private ScrolledComposite createLaunchAttributeControlComposite(Composite parent, int colspan) {
        ScrolledComposite attrComp = new ScrolledComposite(parent, 768);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = colspan;
        attrComp.setLayoutData((Object)gridData);
        attrComp.setExpandHorizontal(true);
        attrComp.setExpandVertical(true);
        return attrComp;
    }

    private IRMLaunchConfigurationDynamicTab createRMLaunchConfigurationDynamicTab(IResourceManager rm) throws CoreException {
        AbstractRMLaunchConfigurationFactory rmFactory = PTPLaunchPlugin.getDefault().getRMLaunchConfigurationFactory(rm);
        if (rmFactory == null) {
            return null;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = rmFactory.create(rm);
        if (rmDynamicTab == null) {
            return null;
        }
        rmDynamicTab.addContentsChangedListener(this.launchContentsChangedListener);
        return rmDynamicTab;
    }

    private ScrolledComposite getLaunchAttrsScrollComposite() {
        return this.launchAttrsScrollComposite;
    }

    private IResourceManager getResourceManagerDefault() {
        IModelManager modelManager = PTPCorePlugin.getDefault().getModelManager();
        IPUniverse universe = modelManager.getUniverse();
        if (universe != null) {
            IResourceManager[] rms = modelManager.getStartedResourceManagers(universe);
            if (rms.length != 1) {
                return null;
            }
            return rms[0];
        }
        return null;
    }

    private IResourceManager getResourceManagerFromCombo() {
        if (this.resourceManagerCombo != null) {
            int i = this.resourceManagerCombo.getSelectionIndex();
            return this.resourceManagers.get(i);
        }
        return null;
    }

    private IRMLaunchConfigurationDynamicTab getRMLaunchConfigurationDynamicTab(IResourceManager rm) {
        if (!this.rmDynamicTabs.containsKey(rm)) {
            try {
                IRMLaunchConfigurationDynamicTab rmDynamicTab = this.createRMLaunchConfigurationDynamicTab(rm);
                this.rmDynamicTabs.put(rm, rmDynamicTab);
                return rmDynamicTab;
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                PTPLaunchPlugin.errorDialog(e.getMessage(), e);
                return null;
            }
        }
        return this.rmDynamicTabs.get(rm);
    }

    private void rmSelectionChanged() {
        this.resourceManager = this.getResourceManagerFromCombo();
    }

    private void setLaunchAttrsScrollComposite(ScrolledComposite comp) {
        this.launchAttrsScrollComposite = comp;
    }

    private void setResourceManagerComboSelection(IResourceManager rm) {
        Integer results = this.resourceManagerIndices.get(rm);
        int i = 0;
        if (results != null) {
            i = results;
        }
        this.resourceManagerCombo.select(i);
        this.rmSelectionChanged();
    }

    private void updateLaunchAttributeControls(IResourceManager rm, IPQueue queue, ILaunchConfiguration launchConfiguration) {
        ScrolledComposite launchAttrsScrollComp = this.getLaunchAttrsScrollComposite();
        launchAttrsScrollComp.setContent(null);
        Control[] controlArray = launchAttrsScrollComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
        if (rmDynamicTab != null) {
            try {
                rmDynamicTab.createControl((Composite)launchAttrsScrollComp, rm, queue);
                Control dynControl = rmDynamicTab.getControl();
                launchAttrsScrollComp.setContent(dynControl);
                Point size = dynControl.computeSize(-1, -1);
                launchAttrsScrollComp.setMinSize(size);
                rmDynamicTab.initializeFrom((Control)launchAttrsScrollComp, rm, queue, launchConfiguration);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                PTPLaunchPlugin.errorDialog(e.getMessage(), e);
            }
        }
        launchAttrsScrollComp.layout(true);
    }

    private final class ContentsChangedListener
    implements IRMLaunchConfigurationContentsChangedListener {
        private ContentsChangedListener() {
        }

        public void handleContentsChanged(IRMLaunchConfigurationDynamicTab rmDynamicTab) {
            ResourcesTab.this.updateLaunchConfigurationDialog();
        }
    }
}

