/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.actions.GotoAction;
import org.eclipse.ptp.ui.actions.GotoDropDownAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;

public class CreateSetAction
extends GotoDropDownAction {
    public static final String name = "Create Set";

    public CreateSetAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_CREATESET_NORMAL);
    }

    protected void createDropDownMenu(MenuManager dropDownMenuMgr) {
        String curID = this.view.getCurrentSetID();
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElement[] iElementArray = setManager.getElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement set = iElementArray[n2];
            this.addAction(dropDownMenuMgr, set.getID(), set.getID(), curID, null);
            ++n2;
        }
    }

    protected void addAction(MenuManager dropDownMenuMgr, String e_name, String id, String curID, Object data) {
        InternalSetAction action = new InternalSetAction("Add to set: " + e_name, id, this.view, this);
        action.setEnabled(!curID.equals(id));
        dropDownMenuMgr.add((IAction)action);
    }

    public void run(IElement[] elements) {
        this.run(elements, null, null);
    }

    public void run(IElement[] elements, String setID, Object data) {
        if (this.validation(elements)) {
            final IElementHandler setManager = this.view.getCurrentElementHandler();
            if (setManager == null) {
                return;
            }
            if (setID == null) {
                IInputValidator inputValidator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.length() == 0) {
                            return "This field cannot be empty.";
                        }
                        if (setManager.contains(newText)) {
                            return "Entered set name (" + newText + ") is already used.";
                        }
                        return null;
                    }
                };
                InputDialog inputDialog = new InputDialog(this.getShell(), "Create a new set name", "Please enter the new set name.", "", inputValidator);
                if (inputDialog.open() == 1) {
                    return;
                }
                String name = inputDialog.getValue();
                setID = this.view.getUIManager().createSet(elements, name, name, setManager);
            } else {
                this.view.getUIManager().addToSet(elements, setID, setManager);
            }
            this.view.selectSet((IElementSet)setManager.getElementByID(setID));
            this.view.refresh(false);
        }
    }

    private class InternalSetAction
    extends GotoAction {
        public InternalSetAction(String name, String id, AbstractParallelElementView view, GotoDropDownAction action) {
            super(name, id, view, action, null);
            this.setImageDescriptor(ParallelImages.ID_ICON_CREATESET_NORMAL);
        }
    }
}

